@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ivschat.kotlin.inputs

import com.pulumi.aws.ivschat.inputs.LoggingConfigurationDestinationConfigurationCloudwatchLogsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property logGroupName Name of the Amazon Cloudwatch Logs destination where chat activity will be logged.
 */
public data class LoggingConfigurationDestinationConfigurationCloudwatchLogsArgs(
    public val logGroupName: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.ivschat.inputs.LoggingConfigurationDestinationConfigurationCloudwatchLogsArgs> {
    override fun toJava(): com.pulumi.aws.ivschat.inputs.LoggingConfigurationDestinationConfigurationCloudwatchLogsArgs =
        com.pulumi.aws.ivschat.inputs.LoggingConfigurationDestinationConfigurationCloudwatchLogsArgs.builder()
            .logGroupName(logGroupName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LoggingConfigurationDestinationConfigurationCloudwatchLogsArgs].
 */
@PulumiTagMarker
public class LoggingConfigurationDestinationConfigurationCloudwatchLogsArgsBuilder internal constructor() {
    private var logGroupName: Output<String>? = null

    /**
     * @param value Name of the Amazon Cloudwatch Logs destination where chat activity will be logged.
     */
    @JvmName("htmbwsqvgsnvhscy")
    public suspend fun logGroupName(`value`: Output<String>) {
        this.logGroupName = value
    }

    /**
     * @param value Name of the Amazon Cloudwatch Logs destination where chat activity will be logged.
     */
    @JvmName("yypwoutepubencbo")
    public suspend fun logGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logGroupName = mapped
    }

    internal fun build(): LoggingConfigurationDestinationConfigurationCloudwatchLogsArgs =
        LoggingConfigurationDestinationConfigurationCloudwatchLogsArgs(
            logGroupName = logGroupName ?: throw PulumiNullFieldException("logGroupName"),
        )
}
