@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ivschat.kotlin.inputs

import com.pulumi.aws.ivschat.inputs.LoggingConfigurationDestinationConfigurationFirehoseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property deliveryStreamName Name of the Amazon Kinesis Firehose delivery stream where chat activity will be logged.
 */
public data class LoggingConfigurationDestinationConfigurationFirehoseArgs(
    public val deliveryStreamName: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.ivschat.inputs.LoggingConfigurationDestinationConfigurationFirehoseArgs> {
    override fun toJava(): com.pulumi.aws.ivschat.inputs.LoggingConfigurationDestinationConfigurationFirehoseArgs =
        com.pulumi.aws.ivschat.inputs.LoggingConfigurationDestinationConfigurationFirehoseArgs.builder()
            .deliveryStreamName(deliveryStreamName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LoggingConfigurationDestinationConfigurationFirehoseArgs].
 */
@PulumiTagMarker
public class LoggingConfigurationDestinationConfigurationFirehoseArgsBuilder internal constructor() {
    private var deliveryStreamName: Output<String>? = null

    /**
     * @param value Name of the Amazon Kinesis Firehose delivery stream where chat activity will be logged.
     */
    @JvmName("hdtkvdphlhsebdmr")
    public suspend fun deliveryStreamName(`value`: Output<String>) {
        this.deliveryStreamName = value
    }

    /**
     * @param value Name of the Amazon Kinesis Firehose delivery stream where chat activity will be logged.
     */
    @JvmName("rjrnwybrptuhjjmt")
    public suspend fun deliveryStreamName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deliveryStreamName = mapped
    }

    internal fun build(): LoggingConfigurationDestinationConfigurationFirehoseArgs =
        LoggingConfigurationDestinationConfigurationFirehoseArgs(
            deliveryStreamName = deliveryStreamName ?: throw PulumiNullFieldException("deliveryStreamName"),
        )
}
