@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ivschat.kotlin.inputs

import com.pulumi.aws.ivschat.inputs.LoggingConfigurationDestinationConfigurationS3Args.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bucketName Name of the Amazon S3 bucket where chat activity will be logged.
 * The following arguments are optional:
 */
public data class LoggingConfigurationDestinationConfigurationS3Args(
    public val bucketName: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.ivschat.inputs.LoggingConfigurationDestinationConfigurationS3Args> {
    override fun toJava(): com.pulumi.aws.ivschat.inputs.LoggingConfigurationDestinationConfigurationS3Args =
        com.pulumi.aws.ivschat.inputs.LoggingConfigurationDestinationConfigurationS3Args.builder()
            .bucketName(bucketName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LoggingConfigurationDestinationConfigurationS3Args].
 */
@PulumiTagMarker
public class LoggingConfigurationDestinationConfigurationS3ArgsBuilder internal constructor() {
    private var bucketName: Output<String>? = null

    /**
     * @param value Name of the Amazon S3 bucket where chat activity will be logged.
     * The following arguments are optional:
     */
    @JvmName("mdjxwhfqucgbepqc")
    public suspend fun bucketName(`value`: Output<String>) {
        this.bucketName = value
    }

    /**
     * @param value Name of the Amazon S3 bucket where chat activity will be logged.
     * The following arguments are optional:
     */
    @JvmName("ytibnvmresknpxoh")
    public suspend fun bucketName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucketName = mapped
    }

    internal fun build(): LoggingConfigurationDestinationConfigurationS3Args =
        LoggingConfigurationDestinationConfigurationS3Args(
            bucketName = bucketName ?: throw PulumiNullFieldException("bucketName"),
        )
}
