@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ivschat.kotlin.inputs

import com.pulumi.aws.ivschat.inputs.RoomMessageReviewHandlerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property fallbackResult The fallback behavior (whether the message
 * is allowed or denied) if the handler does not return a valid response,
 * encounters an error, or times out. Valid values: `ALLOW`, `DENY`.
 * @property uri ARN of the lambda message review handler function.
 */
public data class RoomMessageReviewHandlerArgs(
    public val fallbackResult: Output<String>? = null,
    public val uri: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ivschat.inputs.RoomMessageReviewHandlerArgs> {
    override fun toJava(): com.pulumi.aws.ivschat.inputs.RoomMessageReviewHandlerArgs =
        com.pulumi.aws.ivschat.inputs.RoomMessageReviewHandlerArgs.builder()
            .fallbackResult(fallbackResult?.applyValue({ args0 -> args0 }))
            .uri(uri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RoomMessageReviewHandlerArgs].
 */
@PulumiTagMarker
public class RoomMessageReviewHandlerArgsBuilder internal constructor() {
    private var fallbackResult: Output<String>? = null

    private var uri: Output<String>? = null

    /**
     * @param value The fallback behavior (whether the message
     * is allowed or denied) if the handler does not return a valid response,
     * encounters an error, or times out. Valid values: `ALLOW`, `DENY`.
     */
    @JvmName("ujyftuskbnejgqkd")
    public suspend fun fallbackResult(`value`: Output<String>) {
        this.fallbackResult = value
    }

    /**
     * @param value ARN of the lambda message review handler function.
     */
    @JvmName("vmteovarhcllcwjf")
    public suspend fun uri(`value`: Output<String>) {
        this.uri = value
    }

    /**
     * @param value The fallback behavior (whether the message
     * is allowed or denied) if the handler does not return a valid response,
     * encounters an error, or times out. Valid values: `ALLOW`, `DENY`.
     */
    @JvmName("lpqgftyqfswlrpig")
    public suspend fun fallbackResult(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fallbackResult = mapped
    }

    /**
     * @param value ARN of the lambda message review handler function.
     */
    @JvmName("fhedtxrxfhmtxtkn")
    public suspend fun uri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uri = mapped
    }

    internal fun build(): RoomMessageReviewHandlerArgs = RoomMessageReviewHandlerArgs(
        fallbackResult = fallbackResult,
        uri = uri,
    )
}
