@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ivschat.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property cloudwatchLogs An Amazon CloudWatch Logs destination configuration where chat activity will be logged.
 * @property firehose An Amazon Kinesis Data Firehose destination configuration where chat activity will be logged.
 * @property s3 An Amazon S3 destination configuration where chat activity will be logged.
 */
public data class LoggingConfigurationDestinationConfiguration(
    public val cloudwatchLogs: LoggingConfigurationDestinationConfigurationCloudwatchLogs? = null,
    public val firehose: LoggingConfigurationDestinationConfigurationFirehose? = null,
    public val s3: LoggingConfigurationDestinationConfigurationS3? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ivschat.outputs.LoggingConfigurationDestinationConfiguration): LoggingConfigurationDestinationConfiguration = LoggingConfigurationDestinationConfiguration(
            cloudwatchLogs = javaType.cloudwatchLogs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ivschat.kotlin.outputs.LoggingConfigurationDestinationConfigurationCloudwatchLogs.Companion.toKotlin(args0)
                })
            }).orElse(null),
            firehose = javaType.firehose().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ivschat.kotlin.outputs.LoggingConfigurationDestinationConfigurationFirehose.Companion.toKotlin(args0)
                })
            }).orElse(null),
            s3 = javaType.s3().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ivschat.kotlin.outputs.LoggingConfigurationDestinationConfigurationS3.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
