@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin

import com.pulumi.aws.kendra.kotlin.outputs.ExperienceConfiguration
import com.pulumi.aws.kendra.kotlin.outputs.ExperienceEndpoint
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.kendra.kotlin.outputs.ExperienceConfiguration.Companion.toKotlin as experienceConfigurationToKotlin
import com.pulumi.aws.kendra.kotlin.outputs.ExperienceEndpoint.Companion.toKotlin as experienceEndpointToKotlin

/**
 * Builder for [Experience].
 */
@PulumiTagMarker
public class ExperienceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ExperienceArgs = ExperienceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ExperienceArgsBuilder.() -> Unit) {
        val builder = ExperienceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Experience {
        val builtJavaResource = com.pulumi.aws.kendra.Experience(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Experience(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Kendra Experience.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.kendra.Experience("example", {
 *     indexId: exampleAwsKendraIndex.id,
 *     description: "My Kendra Experience",
 *     name: "example",
 *     roleArn: exampleAwsIamRole.arn,
 *     configuration: {
 *         contentSourceConfiguration: {
 *             directPutContent: true,
 *             faqIds: [exampleAwsKendraFaq&#46;faqId],
 *         },
 *         userIdentityConfiguration: {
 *             identityAttributeName: "12345ec453-1546651e-79c4-4554-91fa-00b43ccfa245",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.kendra.Experience("example",
 *     index_id=example_aws_kendra_index["id"],
 *     description="My Kendra Experience",
 *     name="example",
 *     role_arn=example_aws_iam_role["arn"],
 *     configuration={
 *         "content_source_configuration": {
 *             "direct_put_content": True,
 *             "faq_ids": [example_aws_kendra_faq["faqId"]],
 *         },
 *         "user_identity_configuration": {
 *             "identity_attribute_name": "12345ec453-1546651e-79c4-4554-91fa-00b43ccfa245",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Kendra.Experience("example", new()
 *     {
 *         IndexId = exampleAwsKendraIndex.Id,
 *         Description = "My Kendra Experience",
 *         Name = "example",
 *         RoleArn = exampleAwsIamRole.Arn,
 *         Configuration = new Aws.Kendra.Inputs.ExperienceConfigurationArgs
 *         {
 *             ContentSourceConfiguration = new Aws.Kendra.Inputs.ExperienceConfigurationContentSourceConfigurationArgs
 *             {
 *                 DirectPutContent = true,
 *                 FaqIds = new[]
 *                 {
 *                     exampleAwsKendraFaq.FaqId,
 *                 },
 *             },
 *             UserIdentityConfiguration = new Aws.Kendra.Inputs.ExperienceConfigurationUserIdentityConfigurationArgs
 *             {
 *                 IdentityAttributeName = "12345ec453-1546651e-79c4-4554-91fa-00b43ccfa245",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kendra"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kendra.NewExperience(ctx, "example", &kendra.ExperienceArgs{
 * 			IndexId:     pulumi.Any(exampleAwsKendraIndex.Id),
 * 			Description: pulumi.String("My Kendra Experience"),
 * 			Name:        pulumi.String("example"),
 * 			RoleArn:     pulumi.Any(exampleAwsIamRole.Arn),
 * 			Configuration: &kendra.ExperienceConfigurationArgs{
 * 				ContentSourceConfiguration: &kendra.ExperienceConfigurationContentSourceConfigurationArgs{
 * 					DirectPutContent: pulumi.Bool(true),
 * 					FaqIds: pulumi.StringArray{
 * 						exampleAwsKendraFaq.FaqId,
 * 					},
 * 				},
 * 				UserIdentityConfiguration: &kendra.ExperienceConfigurationUserIdentityConfigurationArgs{
 * 					IdentityAttributeName: pulumi.String("12345ec453-1546651e-79c4-4554-91fa-00b43ccfa245"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.Experience;
 * import com.pulumi.aws.kendra.ExperienceArgs;
 * import com.pulumi.aws.kendra.inputs.ExperienceConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.ExperienceConfigurationContentSourceConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.ExperienceConfigurationUserIdentityConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Experience("example", ExperienceArgs.builder()
 *             .indexId(exampleAwsKendraIndex.id())
 *             .description("My Kendra Experience")
 *             .name("example")
 *             .roleArn(exampleAwsIamRole.arn())
 *             .configuration(ExperienceConfigurationArgs.builder()
 *                 .contentSourceConfiguration(ExperienceConfigurationContentSourceConfigurationArgs.builder()
 *                     .directPutContent(true)
 *                     .faqIds(exampleAwsKendraFaq.faqId())
 *                     .build())
 *                 .userIdentityConfiguration(ExperienceConfigurationUserIdentityConfigurationArgs.builder()
 *                     .identityAttributeName("12345ec453-1546651e-79c4-4554-91fa-00b43ccfa245")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:kendra:Experience
 *     properties:
 *       indexId: ${exampleAwsKendraIndex.id}
 *       description: My Kendra Experience
 *       name: example
 *       roleArn: ${exampleAwsIamRole.arn}
 *       configuration:
 *         contentSourceConfiguration:
 *           directPutContent: true
 *           faqIds:
 *             - ${exampleAwsKendraFaq.faqId}
 *         userIdentityConfiguration:
 *           identityAttributeName: 12345ec453-1546651e-79c4-4554-91fa-00b43ccfa245
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Kendra Experience using the unique identifiers of the experience and index separated by a slash (`/`). For example:
 * ```sh
 * $ pulumi import aws:kendra/experience:Experience example 1045d08d-66ef-4882-b3ed-dfb7df183e90/b34dfdf7-1f2b-4704-9581-79e00296845f
 * ```
 */
public class Experience internal constructor(
    override val javaResource: com.pulumi.aws.kendra.Experience,
) : KotlinCustomResource(javaResource, ExperienceMapper) {
    /**
     * ARN of the Experience.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Configuration information for your Amazon Kendra experience. The provider will only perform drift detection of its value when present in a configuration. Detailed below.
     */
    public val configuration: Output<ExperienceConfiguration>
        get() = javaResource.configuration().applyValue({ args0 ->
            args0.let({ args0 ->
                experienceConfigurationToKotlin(args0)
            })
        })

    /**
     * A description for your Amazon Kendra experience.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Shows the endpoint URLs for your Amazon Kendra experiences. The URLs are unique and fully hosted by AWS.
     */
    public val endpoints: Output<List<ExperienceEndpoint>>
        get() = javaResource.endpoints().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    experienceEndpointToKotlin(args0)
                })
            })
        })

    /**
     * The unique identifier of the experience.
     */
    public val experienceId: Output<String>
        get() = javaResource.experienceId().applyValue({ args0 -> args0 })

    /**
     * The identifier of the index for your Amazon Kendra experience.
     */
    public val indexId: Output<String>
        get() = javaResource.indexId().applyValue({ args0 -> args0 })

    /**
     * A name for your Amazon Kendra experience.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of a role with permission to access `Query API`, `QuerySuggestions API`, `SubmitFeedback API`, and `AWS SSO` that stores your user and group information. For more information, see [IAM roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
     * The following arguments are optional:
     */
    public val roleArn: Output<String>
        get() = javaResource.roleArn().applyValue({ args0 -> args0 })

    /**
     * The current processing status of your Amazon Kendra experience.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object ExperienceMapper : ResourceMapper<Experience> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.kendra.Experience::class == javaResource::class

    override fun map(javaResource: Resource): Experience = Experience(
        javaResource as
            com.pulumi.aws.kendra.Experience,
    )
}

/**
 * @see [Experience].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Experience].
 */
public suspend fun experience(name: String, block: suspend ExperienceResourceBuilder.() -> Unit): Experience {
    val builder = ExperienceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Experience].
 * @param name The _unique_ name of the resulting resource.
 */
public fun experience(name: String): Experience {
    val builder = ExperienceResourceBuilder()
    builder.name(name)
    return builder.build()
}
