@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin

import com.pulumi.aws.kendra.ExperienceArgs.builder
import com.pulumi.aws.kendra.kotlin.inputs.ExperienceConfigurationArgs
import com.pulumi.aws.kendra.kotlin.inputs.ExperienceConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Kendra Experience.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.kendra.Experience("example", {
 *     indexId: exampleAwsKendraIndex.id,
 *     description: "My Kendra Experience",
 *     name: "example",
 *     roleArn: exampleAwsIamRole.arn,
 *     configuration: {
 *         contentSourceConfiguration: {
 *             directPutContent: true,
 *             faqIds: [exampleAwsKendraFaq&#46;faqId],
 *         },
 *         userIdentityConfiguration: {
 *             identityAttributeName: "12345ec453-1546651e-79c4-4554-91fa-00b43ccfa245",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.kendra.Experience("example",
 *     index_id=example_aws_kendra_index["id"],
 *     description="My Kendra Experience",
 *     name="example",
 *     role_arn=example_aws_iam_role["arn"],
 *     configuration={
 *         "content_source_configuration": {
 *             "direct_put_content": True,
 *             "faq_ids": [example_aws_kendra_faq["faqId"]],
 *         },
 *         "user_identity_configuration": {
 *             "identity_attribute_name": "12345ec453-1546651e-79c4-4554-91fa-00b43ccfa245",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Kendra.Experience("example", new()
 *     {
 *         IndexId = exampleAwsKendraIndex.Id,
 *         Description = "My Kendra Experience",
 *         Name = "example",
 *         RoleArn = exampleAwsIamRole.Arn,
 *         Configuration = new Aws.Kendra.Inputs.ExperienceConfigurationArgs
 *         {
 *             ContentSourceConfiguration = new Aws.Kendra.Inputs.ExperienceConfigurationContentSourceConfigurationArgs
 *             {
 *                 DirectPutContent = true,
 *                 FaqIds = new[]
 *                 {
 *                     exampleAwsKendraFaq.FaqId,
 *                 },
 *             },
 *             UserIdentityConfiguration = new Aws.Kendra.Inputs.ExperienceConfigurationUserIdentityConfigurationArgs
 *             {
 *                 IdentityAttributeName = "12345ec453-1546651e-79c4-4554-91fa-00b43ccfa245",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kendra"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kendra.NewExperience(ctx, "example", &kendra.ExperienceArgs{
 * 			IndexId:     pulumi.Any(exampleAwsKendraIndex.Id),
 * 			Description: pulumi.String("My Kendra Experience"),
 * 			Name:        pulumi.String("example"),
 * 			RoleArn:     pulumi.Any(exampleAwsIamRole.Arn),
 * 			Configuration: &kendra.ExperienceConfigurationArgs{
 * 				ContentSourceConfiguration: &kendra.ExperienceConfigurationContentSourceConfigurationArgs{
 * 					DirectPutContent: pulumi.Bool(true),
 * 					FaqIds: pulumi.StringArray{
 * 						exampleAwsKendraFaq.FaqId,
 * 					},
 * 				},
 * 				UserIdentityConfiguration: &kendra.ExperienceConfigurationUserIdentityConfigurationArgs{
 * 					IdentityAttributeName: pulumi.String("12345ec453-1546651e-79c4-4554-91fa-00b43ccfa245"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.Experience;
 * import com.pulumi.aws.kendra.ExperienceArgs;
 * import com.pulumi.aws.kendra.inputs.ExperienceConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.ExperienceConfigurationContentSourceConfigurationArgs;
 * import com.pulumi.aws.kendra.inputs.ExperienceConfigurationUserIdentityConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Experience("example", ExperienceArgs.builder()
 *             .indexId(exampleAwsKendraIndex.id())
 *             .description("My Kendra Experience")
 *             .name("example")
 *             .roleArn(exampleAwsIamRole.arn())
 *             .configuration(ExperienceConfigurationArgs.builder()
 *                 .contentSourceConfiguration(ExperienceConfigurationContentSourceConfigurationArgs.builder()
 *                     .directPutContent(true)
 *                     .faqIds(exampleAwsKendraFaq.faqId())
 *                     .build())
 *                 .userIdentityConfiguration(ExperienceConfigurationUserIdentityConfigurationArgs.builder()
 *                     .identityAttributeName("12345ec453-1546651e-79c4-4554-91fa-00b43ccfa245")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:kendra:Experience
 *     properties:
 *       indexId: ${exampleAwsKendraIndex.id}
 *       description: My Kendra Experience
 *       name: example
 *       roleArn: ${exampleAwsIamRole.arn}
 *       configuration:
 *         contentSourceConfiguration:
 *           directPutContent: true
 *           faqIds:
 *             - ${exampleAwsKendraFaq.faqId}
 *         userIdentityConfiguration:
 *           identityAttributeName: 12345ec453-1546651e-79c4-4554-91fa-00b43ccfa245
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Kendra Experience using the unique identifiers of the experience and index separated by a slash (`/`). For example:
 * ```sh
 * $ pulumi import aws:kendra/experience:Experience example 1045d08d-66ef-4882-b3ed-dfb7df183e90/b34dfdf7-1f2b-4704-9581-79e00296845f
 * ```
 * @property configuration Configuration information for your Amazon Kendra experience. The provider will only perform drift detection of its value when present in a configuration. Detailed below.
 * @property description A description for your Amazon Kendra experience.
 * @property indexId The identifier of the index for your Amazon Kendra experience.
 * @property name A name for your Amazon Kendra experience.
 * @property roleArn The Amazon Resource Name (ARN) of a role with permission to access `Query API`, `QuerySuggestions API`, `SubmitFeedback API`, and `AWS SSO` that stores your user and group information. For more information, see [IAM roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
 * The following arguments are optional:
 */
public data class ExperienceArgs(
    public val configuration: Output<ExperienceConfigurationArgs>? = null,
    public val description: Output<String>? = null,
    public val indexId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val roleArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.kendra.ExperienceArgs> {
    override fun toJava(): com.pulumi.aws.kendra.ExperienceArgs =
        com.pulumi.aws.kendra.ExperienceArgs.builder()
            .configuration(configuration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .indexId(indexId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExperienceArgs].
 */
@PulumiTagMarker
public class ExperienceArgsBuilder internal constructor() {
    private var configuration: Output<ExperienceConfigurationArgs>? = null

    private var description: Output<String>? = null

    private var indexId: Output<String>? = null

    private var name: Output<String>? = null

    private var roleArn: Output<String>? = null

    /**
     * @param value Configuration information for your Amazon Kendra experience. The provider will only perform drift detection of its value when present in a configuration. Detailed below.
     */
    @JvmName("shcdhwfvrhemrjek")
    public suspend fun configuration(`value`: Output<ExperienceConfigurationArgs>) {
        this.configuration = value
    }

    /**
     * @param value A description for your Amazon Kendra experience.
     */
    @JvmName("hbvblbfqntsdcyfy")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The identifier of the index for your Amazon Kendra experience.
     */
    @JvmName("adrdyeogyjnlmuvb")
    public suspend fun indexId(`value`: Output<String>) {
        this.indexId = value
    }

    /**
     * @param value A name for your Amazon Kendra experience.
     */
    @JvmName("iavxmraubwiqdgee")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of a role with permission to access `Query API`, `QuerySuggestions API`, `SubmitFeedback API`, and `AWS SSO` that stores your user and group information. For more information, see [IAM roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
     * The following arguments are optional:
     */
    @JvmName("lrsupbbndqcxysbo")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value Configuration information for your Amazon Kendra experience. The provider will only perform drift detection of its value when present in a configuration. Detailed below.
     */
    @JvmName("ehryjbfydnpfqabn")
    public suspend fun configuration(`value`: ExperienceConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configuration = mapped
    }

    /**
     * @param argument Configuration information for your Amazon Kendra experience. The provider will only perform drift detection of its value when present in a configuration. Detailed below.
     */
    @JvmName("jwqsqvpwvakqsbeu")
    public suspend fun configuration(argument: suspend ExperienceConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ExperienceConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.configuration = mapped
    }

    /**
     * @param value A description for your Amazon Kendra experience.
     */
    @JvmName("tmpfmwfyfqgldgfi")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The identifier of the index for your Amazon Kendra experience.
     */
    @JvmName("ohdvkduhbgwpcdkd")
    public suspend fun indexId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.indexId = mapped
    }

    /**
     * @param value A name for your Amazon Kendra experience.
     */
    @JvmName("ubcxepotcwluurvn")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of a role with permission to access `Query API`, `QuerySuggestions API`, `SubmitFeedback API`, and `AWS SSO` that stores your user and group information. For more information, see [IAM roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
     * The following arguments are optional:
     */
    @JvmName("ykehnbskxnlewmen")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    internal fun build(): ExperienceArgs = ExperienceArgs(
        configuration = configuration,
        description = description,
        indexId = indexId,
        name = name,
        roleArn = roleArn,
    )
}
