@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin

import com.pulumi.aws.kendra.FaqArgs.builder
import com.pulumi.aws.kendra.kotlin.inputs.FaqS3PathArgs
import com.pulumi.aws.kendra.kotlin.inputs.FaqS3PathArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Kendra FAQ.
 * ## Example Usage
 * ### Basic
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.kendra.Faq("example", {
 *     indexId: exampleAwsKendraIndex.id,
 *     name: "Example",
 *     roleArn: exampleAwsIamRole.arn,
 *     s3Path: {
 *         bucket: exampleAwsS3Bucket.id,
 *         key: exampleAwsS3Object.key,
 *     },
 *     tags: {
 *         Name: "Example Kendra Faq",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.kendra.Faq("example",
 *     index_id=example_aws_kendra_index["id"],
 *     name="Example",
 *     role_arn=example_aws_iam_role["arn"],
 *     s3_path={
 *         "bucket": example_aws_s3_bucket["id"],
 *         "key": example_aws_s3_object["key"],
 *     },
 *     tags={
 *         "Name": "Example Kendra Faq",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Kendra.Faq("example", new()
 *     {
 *         IndexId = exampleAwsKendraIndex.Id,
 *         Name = "Example",
 *         RoleArn = exampleAwsIamRole.Arn,
 *         S3Path = new Aws.Kendra.Inputs.FaqS3PathArgs
 *         {
 *             Bucket = exampleAwsS3Bucket.Id,
 *             Key = exampleAwsS3Object.Key,
 *         },
 *         Tags =
 *         {
 *             { "Name", "Example Kendra Faq" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kendra"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kendra.NewFaq(ctx, "example", &kendra.FaqArgs{
 * 			IndexId: pulumi.Any(exampleAwsKendraIndex.Id),
 * 			Name:    pulumi.String("Example"),
 * 			RoleArn: pulumi.Any(exampleAwsIamRole.Arn),
 * 			S3Path: &kendra.FaqS3PathArgs{
 * 				Bucket: pulumi.Any(exampleAwsS3Bucket.Id),
 * 				Key:    pulumi.Any(exampleAwsS3Object.Key),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("Example Kendra Faq"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.Faq;
 * import com.pulumi.aws.kendra.FaqArgs;
 * import com.pulumi.aws.kendra.inputs.FaqS3PathArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Faq("example", FaqArgs.builder()
 *             .indexId(exampleAwsKendraIndex.id())
 *             .name("Example")
 *             .roleArn(exampleAwsIamRole.arn())
 *             .s3Path(FaqS3PathArgs.builder()
 *                 .bucket(exampleAwsS3Bucket.id())
 *                 .key(exampleAwsS3Object.key())
 *                 .build())
 *             .tags(Map.of("Name", "Example Kendra Faq"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:kendra:Faq
 *     properties:
 *       indexId: ${exampleAwsKendraIndex.id}
 *       name: Example
 *       roleArn: ${exampleAwsIamRole.arn}
 *       s3Path:
 *         bucket: ${exampleAwsS3Bucket.id}
 *         key: ${exampleAwsS3Object.key}
 *       tags:
 *         Name: Example Kendra Faq
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With File Format
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.kendra.Faq("example", {
 *     indexId: exampleAwsKendraIndex.id,
 *     name: "Example",
 *     fileFormat: "CSV",
 *     roleArn: exampleAwsIamRole.arn,
 *     s3Path: {
 *         bucket: exampleAwsS3Bucket.id,
 *         key: exampleAwsS3Object.key,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.kendra.Faq("example",
 *     index_id=example_aws_kendra_index["id"],
 *     name="Example",
 *     file_format="CSV",
 *     role_arn=example_aws_iam_role["arn"],
 *     s3_path={
 *         "bucket": example_aws_s3_bucket["id"],
 *         "key": example_aws_s3_object["key"],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Kendra.Faq("example", new()
 *     {
 *         IndexId = exampleAwsKendraIndex.Id,
 *         Name = "Example",
 *         FileFormat = "CSV",
 *         RoleArn = exampleAwsIamRole.Arn,
 *         S3Path = new Aws.Kendra.Inputs.FaqS3PathArgs
 *         {
 *             Bucket = exampleAwsS3Bucket.Id,
 *             Key = exampleAwsS3Object.Key,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kendra"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kendra.NewFaq(ctx, "example", &kendra.FaqArgs{
 * 			IndexId:    pulumi.Any(exampleAwsKendraIndex.Id),
 * 			Name:       pulumi.String("Example"),
 * 			FileFormat: pulumi.String("CSV"),
 * 			RoleArn:    pulumi.Any(exampleAwsIamRole.Arn),
 * 			S3Path: &kendra.FaqS3PathArgs{
 * 				Bucket: pulumi.Any(exampleAwsS3Bucket.Id),
 * 				Key:    pulumi.Any(exampleAwsS3Object.Key),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.Faq;
 * import com.pulumi.aws.kendra.FaqArgs;
 * import com.pulumi.aws.kendra.inputs.FaqS3PathArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Faq("example", FaqArgs.builder()
 *             .indexId(exampleAwsKendraIndex.id())
 *             .name("Example")
 *             .fileFormat("CSV")
 *             .roleArn(exampleAwsIamRole.arn())
 *             .s3Path(FaqS3PathArgs.builder()
 *                 .bucket(exampleAwsS3Bucket.id())
 *                 .key(exampleAwsS3Object.key())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:kendra:Faq
 *     properties:
 *       indexId: ${exampleAwsKendraIndex.id}
 *       name: Example
 *       fileFormat: CSV
 *       roleArn: ${exampleAwsIamRole.arn}
 *       s3Path:
 *         bucket: ${exampleAwsS3Bucket.id}
 *         key: ${exampleAwsS3Object.key}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With Language Code
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.kendra.Faq("example", {
 *     indexId: exampleAwsKendraIndex.id,
 *     name: "Example",
 *     languageCode: "en",
 *     roleArn: exampleAwsIamRole.arn,
 *     s3Path: {
 *         bucket: exampleAwsS3Bucket.id,
 *         key: exampleAwsS3Object.key,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.kendra.Faq("example",
 *     index_id=example_aws_kendra_index["id"],
 *     name="Example",
 *     language_code="en",
 *     role_arn=example_aws_iam_role["arn"],
 *     s3_path={
 *         "bucket": example_aws_s3_bucket["id"],
 *         "key": example_aws_s3_object["key"],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Kendra.Faq("example", new()
 *     {
 *         IndexId = exampleAwsKendraIndex.Id,
 *         Name = "Example",
 *         LanguageCode = "en",
 *         RoleArn = exampleAwsIamRole.Arn,
 *         S3Path = new Aws.Kendra.Inputs.FaqS3PathArgs
 *         {
 *             Bucket = exampleAwsS3Bucket.Id,
 *             Key = exampleAwsS3Object.Key,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kendra"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kendra.NewFaq(ctx, "example", &kendra.FaqArgs{
 * 			IndexId:      pulumi.Any(exampleAwsKendraIndex.Id),
 * 			Name:         pulumi.String("Example"),
 * 			LanguageCode: pulumi.String("en"),
 * 			RoleArn:      pulumi.Any(exampleAwsIamRole.Arn),
 * 			S3Path: &kendra.FaqS3PathArgs{
 * 				Bucket: pulumi.Any(exampleAwsS3Bucket.Id),
 * 				Key:    pulumi.Any(exampleAwsS3Object.Key),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.Faq;
 * import com.pulumi.aws.kendra.FaqArgs;
 * import com.pulumi.aws.kendra.inputs.FaqS3PathArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Faq("example", FaqArgs.builder()
 *             .indexId(exampleAwsKendraIndex.id())
 *             .name("Example")
 *             .languageCode("en")
 *             .roleArn(exampleAwsIamRole.arn())
 *             .s3Path(FaqS3PathArgs.builder()
 *                 .bucket(exampleAwsS3Bucket.id())
 *                 .key(exampleAwsS3Object.key())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:kendra:Faq
 *     properties:
 *       indexId: ${exampleAwsKendraIndex.id}
 *       name: Example
 *       languageCode: en
 *       roleArn: ${exampleAwsIamRole.arn}
 *       s3Path:
 *         bucket: ${exampleAwsS3Bucket.id}
 *         key: ${exampleAwsS3Object.key}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_kendra_faq` using the unique identifiers of the FAQ and index separated by a slash (`/`). For example:
 * ```sh
 * $ pulumi import aws:kendra/faq:Faq example faq-123456780/idx-8012925589
 * ```
 * @property description
 * @property fileFormat
 * @property indexId The identifier of the index for a FAQ.
 * @property languageCode
 * @property name The name that should be associated with the FAQ.
 * @property roleArn The Amazon Resource Name (ARN) of a role with permission to access the S3 bucket that contains the FAQs. For more information, see [IAM Roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
 * @property s3Path The S3 location of the FAQ input data. Detailed below.
 * @property tags
 */
public data class FaqArgs(
    public val description: Output<String>? = null,
    public val fileFormat: Output<String>? = null,
    public val indexId: Output<String>? = null,
    public val languageCode: Output<String>? = null,
    public val name: Output<String>? = null,
    public val roleArn: Output<String>? = null,
    public val s3Path: Output<FaqS3PathArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.kendra.FaqArgs> {
    override fun toJava(): com.pulumi.aws.kendra.FaqArgs = com.pulumi.aws.kendra.FaqArgs.builder()
        .description(description?.applyValue({ args0 -> args0 }))
        .fileFormat(fileFormat?.applyValue({ args0 -> args0 }))
        .indexId(indexId?.applyValue({ args0 -> args0 }))
        .languageCode(languageCode?.applyValue({ args0 -> args0 }))
        .name(name?.applyValue({ args0 -> args0 }))
        .roleArn(roleArn?.applyValue({ args0 -> args0 }))
        .s3Path(s3Path?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .tags(
            tags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        ).build()
}

/**
 * Builder for [FaqArgs].
 */
@PulumiTagMarker
public class FaqArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var fileFormat: Output<String>? = null

    private var indexId: Output<String>? = null

    private var languageCode: Output<String>? = null

    private var name: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var s3Path: Output<FaqS3PathArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value
     */
    @JvmName("gaqskaxiukvtfojb")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value
     */
    @JvmName("yaotuhfftrtjvxet")
    public suspend fun fileFormat(`value`: Output<String>) {
        this.fileFormat = value
    }

    /**
     * @param value The identifier of the index for a FAQ.
     */
    @JvmName("xohkoipbcgueopju")
    public suspend fun indexId(`value`: Output<String>) {
        this.indexId = value
    }

    /**
     * @param value
     */
    @JvmName("vkmkhwbayouugafl")
    public suspend fun languageCode(`value`: Output<String>) {
        this.languageCode = value
    }

    /**
     * @param value The name that should be associated with the FAQ.
     */
    @JvmName("kmxaaeraupsybtlt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of a role with permission to access the S3 bucket that contains the FAQs. For more information, see [IAM Roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
     */
    @JvmName("tjawcafvnpsusifg")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The S3 location of the FAQ input data. Detailed below.
     */
    @JvmName("vjrokjrqfdiprtnl")
    public suspend fun s3Path(`value`: Output<FaqS3PathArgs>) {
        this.s3Path = value
    }

    /**
     * @param value
     */
    @JvmName("kjjslldrtcndaakg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("vuxsfphjekbkopjx")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value
     */
    @JvmName("pvvfohucwegpvuep")
    public suspend fun fileFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileFormat = mapped
    }

    /**
     * @param value The identifier of the index for a FAQ.
     */
    @JvmName("dbmyivsexhgcxotn")
    public suspend fun indexId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.indexId = mapped
    }

    /**
     * @param value
     */
    @JvmName("cuahcrxroyuvlpxr")
    public suspend fun languageCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.languageCode = mapped
    }

    /**
     * @param value The name that should be associated with the FAQ.
     */
    @JvmName("aafvwdfpydyfpbst")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of a role with permission to access the S3 bucket that contains the FAQs. For more information, see [IAM Roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
     */
    @JvmName("sxuhlldafxiynuoo")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value The S3 location of the FAQ input data. Detailed below.
     */
    @JvmName("arsugigyfylfpcav")
    public suspend fun s3Path(`value`: FaqS3PathArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Path = mapped
    }

    /**
     * @param argument The S3 location of the FAQ input data. Detailed below.
     */
    @JvmName("ykpmodeaufsbhlkt")
    public suspend fun s3Path(argument: suspend FaqS3PathArgsBuilder.() -> Unit) {
        val toBeMapped = FaqS3PathArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.s3Path = mapped
    }

    /**
     * @param value
     */
    @JvmName("mddskwfewsvgjlkw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("tuaomrjqowxbmnoi")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): FaqArgs = FaqArgs(
        description = description,
        fileFormat = fileFormat,
        indexId = indexId,
        languageCode = languageCode,
        name = name,
        roleArn = roleArn,
        s3Path = s3Path,
        tags = tags,
    )
}
