@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin

import com.pulumi.aws.kendra.KendraFunctions.getExperiencePlain
import com.pulumi.aws.kendra.KendraFunctions.getFaqPlain
import com.pulumi.aws.kendra.KendraFunctions.getIndexPlain
import com.pulumi.aws.kendra.KendraFunctions.getQuerySuggestionsBlockListPlain
import com.pulumi.aws.kendra.KendraFunctions.getThesaurusPlain
import com.pulumi.aws.kendra.kotlin.inputs.GetExperiencePlainArgs
import com.pulumi.aws.kendra.kotlin.inputs.GetExperiencePlainArgsBuilder
import com.pulumi.aws.kendra.kotlin.inputs.GetFaqPlainArgs
import com.pulumi.aws.kendra.kotlin.inputs.GetFaqPlainArgsBuilder
import com.pulumi.aws.kendra.kotlin.inputs.GetIndexPlainArgs
import com.pulumi.aws.kendra.kotlin.inputs.GetIndexPlainArgsBuilder
import com.pulumi.aws.kendra.kotlin.inputs.GetQuerySuggestionsBlockListPlainArgs
import com.pulumi.aws.kendra.kotlin.inputs.GetQuerySuggestionsBlockListPlainArgsBuilder
import com.pulumi.aws.kendra.kotlin.inputs.GetThesaurusPlainArgs
import com.pulumi.aws.kendra.kotlin.inputs.GetThesaurusPlainArgsBuilder
import com.pulumi.aws.kendra.kotlin.outputs.GetExperienceResult
import com.pulumi.aws.kendra.kotlin.outputs.GetFaqResult
import com.pulumi.aws.kendra.kotlin.outputs.GetIndexResult
import com.pulumi.aws.kendra.kotlin.outputs.GetQuerySuggestionsBlockListResult
import com.pulumi.aws.kendra.kotlin.outputs.GetThesaurusResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.kendra.kotlin.outputs.GetExperienceResult.Companion.toKotlin as getExperienceResultToKotlin
import com.pulumi.aws.kendra.kotlin.outputs.GetFaqResult.Companion.toKotlin as getFaqResultToKotlin
import com.pulumi.aws.kendra.kotlin.outputs.GetIndexResult.Companion.toKotlin as getIndexResultToKotlin
import com.pulumi.aws.kendra.kotlin.outputs.GetQuerySuggestionsBlockListResult.Companion.toKotlin as getQuerySuggestionsBlockListResultToKotlin
import com.pulumi.aws.kendra.kotlin.outputs.GetThesaurusResult.Companion.toKotlin as getThesaurusResultToKotlin

public object KendraFunctions {
    /**
     * Provides details about a specific Amazon Kendra Experience.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.kendra.getExperience({
     *     experienceId: "87654321-1234-4321-4321-321987654321",
     *     indexId: "12345678-1234-1234-1234-123456789123",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.kendra.get_experience(experience_id="87654321-1234-4321-4321-321987654321",
     *     index_id="12345678-1234-1234-1234-123456789123")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Kendra.GetExperience.Invoke(new()
     *     {
     *         ExperienceId = "87654321-1234-4321-4321-321987654321",
     *         IndexId = "12345678-1234-1234-1234-123456789123",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kendra"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := kendra.LookupExperience(ctx, &kendra.LookupExperienceArgs{
     * 			ExperienceId: "87654321-1234-4321-4321-321987654321",
     * 			IndexId:      "12345678-1234-1234-1234-123456789123",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.kendra.KendraFunctions;
     * import com.pulumi.aws.kendra.inputs.GetExperienceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = KendraFunctions.getExperience(GetExperienceArgs.builder()
     *             .experienceId("87654321-1234-4321-4321-321987654321")
     *             .indexId("12345678-1234-1234-1234-123456789123")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:kendra:getExperience
     *       Arguments:
     *         experienceId: 87654321-1234-4321-4321-321987654321
     *         indexId: 12345678-1234-1234-1234-123456789123
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getExperience.
     * @return A collection of values returned by getExperience.
     */
    public suspend fun getExperience(argument: GetExperiencePlainArgs): GetExperienceResult =
        getExperienceResultToKotlin(getExperiencePlain(argument.toJava()).await())

    /**
     * @see [getExperience].
     * @param experienceId Identifier of the Experience.
     * @param indexId Identifier of the index that contains the Experience.
     * @return A collection of values returned by getExperience.
     */
    public suspend fun getExperience(experienceId: String, indexId: String): GetExperienceResult {
        val argument = GetExperiencePlainArgs(
            experienceId = experienceId,
            indexId = indexId,
        )
        return getExperienceResultToKotlin(getExperiencePlain(argument.toJava()).await())
    }

    /**
     * @see [getExperience].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;kendra&#46;kotlin&#46;inputs&#46;GetExperiencePlainArgs].
     * @return A collection of values returned by getExperience.
     */
    public suspend fun getExperience(argument: suspend GetExperiencePlainArgsBuilder.() -> Unit): GetExperienceResult {
        val builder = GetExperiencePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getExperienceResultToKotlin(getExperiencePlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about a specific Amazon Kendra Faq.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.kendra.getFaq({
     *     faqId: "87654321-1234-4321-4321-321987654321",
     *     indexId: "12345678-1234-1234-1234-123456789123",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.kendra.get_faq(faq_id="87654321-1234-4321-4321-321987654321",
     *     index_id="12345678-1234-1234-1234-123456789123")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.Kendra.GetFaq.Invoke(new()
     *     {
     *         FaqId = "87654321-1234-4321-4321-321987654321",
     *         IndexId = "12345678-1234-1234-1234-123456789123",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kendra"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := kendra.LookupFaq(ctx, &kendra.LookupFaqArgs{
     * 			FaqId:   "87654321-1234-4321-4321-321987654321",
     * 			IndexId: "12345678-1234-1234-1234-123456789123",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.kendra.KendraFunctions;
     * import com.pulumi.aws.kendra.inputs.GetFaqArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = KendraFunctions.getFaq(GetFaqArgs.builder()
     *             .faqId("87654321-1234-4321-4321-321987654321")
     *             .indexId("12345678-1234-1234-1234-123456789123")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:kendra:getFaq
     *       Arguments:
     *         faqId: 87654321-1234-4321-4321-321987654321
     *         indexId: 12345678-1234-1234-1234-123456789123
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getFaq.
     * @return A collection of values returned by getFaq.
     */
    public suspend fun getFaq(argument: GetFaqPlainArgs): GetFaqResult =
        getFaqResultToKotlin(getFaqPlain(argument.toJava()).await())

    /**
     * @see [getFaq].
     * @param faqId Identifier of the FAQ.
     * @param indexId Identifier of the index that contains the FAQ.
     * @param tags Metadata that helps organize the FAQs you create.
     * @return A collection of values returned by getFaq.
     */
    public suspend fun getFaq(
        faqId: String,
        indexId: String,
        tags: Map<String, String>? = null,
    ): GetFaqResult {
        val argument = GetFaqPlainArgs(
            faqId = faqId,
            indexId = indexId,
            tags = tags,
        )
        return getFaqResultToKotlin(getFaqPlain(argument.toJava()).await())
    }

    /**
     * @see [getFaq].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;kendra&#46;kotlin&#46;inputs&#46;GetFaqPlainArgs].
     * @return A collection of values returned by getFaq.
     */
    public suspend fun getFaq(argument: suspend GetFaqPlainArgsBuilder.() -> Unit): GetFaqResult {
        val builder = GetFaqPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFaqResultToKotlin(getFaqPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about a specific Amazon Kendra Index.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.kendra.getIndex({
     *     id: "12345678-1234-1234-1234-123456789123",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.kendra.get_index(id="12345678-1234-1234-1234-123456789123")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Kendra.GetIndex.Invoke(new()
     *     {
     *         Id = "12345678-1234-1234-1234-123456789123",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kendra"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := kendra.LookupIndex(ctx, &kendra.LookupIndexArgs{
     * 			Id: "12345678-1234-1234-1234-123456789123",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.kendra.KendraFunctions;
     * import com.pulumi.aws.kendra.inputs.GetIndexArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = KendraFunctions.getIndex(GetIndexArgs.builder()
     *             .id("12345678-1234-1234-1234-123456789123")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:kendra:getIndex
     *       Arguments:
     *         id: 12345678-1234-1234-1234-123456789123
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getIndex.
     * @return A collection of values returned by getIndex.
     */
    public suspend fun getIndex(argument: GetIndexPlainArgs): GetIndexResult =
        getIndexResultToKotlin(getIndexPlain(argument.toJava()).await())

    /**
     * @see [getIndex].
     * @param id Returns information on a specific Index by id.
     * @param tags Metadata that helps organize the Indices you create.
     * @return A collection of values returned by getIndex.
     */
    public suspend fun getIndex(id: String, tags: Map<String, String>? = null): GetIndexResult {
        val argument = GetIndexPlainArgs(
            id = id,
            tags = tags,
        )
        return getIndexResultToKotlin(getIndexPlain(argument.toJava()).await())
    }

    /**
     * @see [getIndex].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;kendra&#46;kotlin&#46;inputs&#46;GetIndexPlainArgs].
     * @return A collection of values returned by getIndex.
     */
    public suspend fun getIndex(argument: suspend GetIndexPlainArgsBuilder.() -> Unit): GetIndexResult {
        val builder = GetIndexPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIndexResultToKotlin(getIndexPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about a specific Amazon Kendra block list used for query suggestions for an index.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.kendra.getQuerySuggestionsBlockList({
     *     indexId: "12345678-1234-1234-1234-123456789123",
     *     querySuggestionsBlockListId: "87654321-1234-4321-4321-321987654321",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.kendra.get_query_suggestions_block_list(index_id="12345678-1234-1234-1234-123456789123",
     *     query_suggestions_block_list_id="87654321-1234-4321-4321-321987654321")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Kendra.GetQuerySuggestionsBlockList.Invoke(new()
     *     {
     *         IndexId = "12345678-1234-1234-1234-123456789123",
     *         QuerySuggestionsBlockListId = "87654321-1234-4321-4321-321987654321",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kendra"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := kendra.LookupQuerySuggestionsBlockList(ctx, &kendra.LookupQuerySuggestionsBlockListArgs{
     * 			IndexId:                     "12345678-1234-1234-1234-123456789123",
     * 			QuerySuggestionsBlockListId: "87654321-1234-4321-4321-321987654321",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.kendra.KendraFunctions;
     * import com.pulumi.aws.kendra.inputs.GetQuerySuggestionsBlockListArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = KendraFunctions.getQuerySuggestionsBlockList(GetQuerySuggestionsBlockListArgs.builder()
     *             .indexId("12345678-1234-1234-1234-123456789123")
     *             .querySuggestionsBlockListId("87654321-1234-4321-4321-321987654321")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:kendra:getQuerySuggestionsBlockList
     *       Arguments:
     *         indexId: 12345678-1234-1234-1234-123456789123
     *         querySuggestionsBlockListId: 87654321-1234-4321-4321-321987654321
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getQuerySuggestionsBlockList.
     * @return A collection of values returned by getQuerySuggestionsBlockList.
     */
    public suspend fun getQuerySuggestionsBlockList(argument: GetQuerySuggestionsBlockListPlainArgs): GetQuerySuggestionsBlockListResult =
        getQuerySuggestionsBlockListResultToKotlin(getQuerySuggestionsBlockListPlain(argument.toJava()).await())

    /**
     * @see [getQuerySuggestionsBlockList].
     * @param indexId Identifier of the index that contains the block list.
     * @param querySuggestionsBlockListId Identifier of the block list.
     * @param tags Metadata that helps organize the block list you create.
     * @return A collection of values returned by getQuerySuggestionsBlockList.
     */
    public suspend fun getQuerySuggestionsBlockList(
        indexId: String,
        querySuggestionsBlockListId: String,
        tags: Map<String, String>? = null,
    ): GetQuerySuggestionsBlockListResult {
        val argument = GetQuerySuggestionsBlockListPlainArgs(
            indexId = indexId,
            querySuggestionsBlockListId = querySuggestionsBlockListId,
            tags = tags,
        )
        return getQuerySuggestionsBlockListResultToKotlin(getQuerySuggestionsBlockListPlain(argument.toJava()).await())
    }

    /**
     * @see [getQuerySuggestionsBlockList].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;kendra&#46;kotlin&#46;inputs&#46;GetQuerySuggestionsBlockListPlainArgs].
     * @return A collection of values returned by getQuerySuggestionsBlockList.
     */
    public suspend fun getQuerySuggestionsBlockList(argument: suspend GetQuerySuggestionsBlockListPlainArgsBuilder.() -> Unit): GetQuerySuggestionsBlockListResult {
        val builder = GetQuerySuggestionsBlockListPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getQuerySuggestionsBlockListResultToKotlin(getQuerySuggestionsBlockListPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about a specific Amazon Kendra Thesaurus.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.kendra.getThesaurus({
     *     indexId: "12345678-1234-1234-1234-123456789123",
     *     thesaurusId: "87654321-1234-4321-4321-321987654321",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.kendra.get_thesaurus(index_id="12345678-1234-1234-1234-123456789123",
     *     thesaurus_id="87654321-1234-4321-4321-321987654321")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Kendra.GetThesaurus.Invoke(new()
     *     {
     *         IndexId = "12345678-1234-1234-1234-123456789123",
     *         ThesaurusId = "87654321-1234-4321-4321-321987654321",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kendra"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := kendra.LookupThesaurus(ctx, &kendra.LookupThesaurusArgs{
     * 			IndexId:     "12345678-1234-1234-1234-123456789123",
     * 			ThesaurusId: "87654321-1234-4321-4321-321987654321",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.kendra.KendraFunctions;
     * import com.pulumi.aws.kendra.inputs.GetThesaurusArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = KendraFunctions.getThesaurus(GetThesaurusArgs.builder()
     *             .indexId("12345678-1234-1234-1234-123456789123")
     *             .thesaurusId("87654321-1234-4321-4321-321987654321")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:kendra:getThesaurus
     *       Arguments:
     *         indexId: 12345678-1234-1234-1234-123456789123
     *         thesaurusId: 87654321-1234-4321-4321-321987654321
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getThesaurus.
     * @return A collection of values returned by getThesaurus.
     */
    public suspend fun getThesaurus(argument: GetThesaurusPlainArgs): GetThesaurusResult =
        getThesaurusResultToKotlin(getThesaurusPlain(argument.toJava()).await())

    /**
     * @see [getThesaurus].
     * @param indexId Identifier of the index that contains the Thesaurus.
     * @param tags Metadata that helps organize the Thesaurus you create.
     * @param thesaurusId Identifier of the Thesaurus.
     * @return A collection of values returned by getThesaurus.
     */
    public suspend fun getThesaurus(
        indexId: String,
        tags: Map<String, String>? = null,
        thesaurusId: String,
    ): GetThesaurusResult {
        val argument = GetThesaurusPlainArgs(
            indexId = indexId,
            tags = tags,
            thesaurusId = thesaurusId,
        )
        return getThesaurusResultToKotlin(getThesaurusPlain(argument.toJava()).await())
    }

    /**
     * @see [getThesaurus].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;kendra&#46;kotlin&#46;inputs&#46;GetThesaurusPlainArgs].
     * @return A collection of values returned by getThesaurus.
     */
    public suspend fun getThesaurus(argument: suspend GetThesaurusPlainArgsBuilder.() -> Unit): GetThesaurusResult {
        val builder = GetThesaurusPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getThesaurusResultToKotlin(getThesaurusPlain(builtArgument.toJava()).await())
    }
}
