@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin

import com.pulumi.aws.kendra.ThesaurusArgs.builder
import com.pulumi.aws.kendra.kotlin.inputs.ThesaurusSourceS3PathArgs
import com.pulumi.aws.kendra.kotlin.inputs.ThesaurusSourceS3PathArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Kendra Thesaurus.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.kendra.Thesaurus("example", {
 *     indexId: exampleAwsKendraIndex.id,
 *     name: "Example",
 *     roleArn: exampleAwsIamRole.arn,
 *     sourceS3Path: {
 *         bucket: exampleAwsS3Bucket.id,
 *         key: exampleAwsS3Object.key,
 *     },
 *     tags: {
 *         Name: "Example Kendra Thesaurus",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.kendra.Thesaurus("example",
 *     index_id=example_aws_kendra_index["id"],
 *     name="Example",
 *     role_arn=example_aws_iam_role["arn"],
 *     source_s3_path={
 *         "bucket": example_aws_s3_bucket["id"],
 *         "key": example_aws_s3_object["key"],
 *     },
 *     tags={
 *         "Name": "Example Kendra Thesaurus",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Kendra.Thesaurus("example", new()
 *     {
 *         IndexId = exampleAwsKendraIndex.Id,
 *         Name = "Example",
 *         RoleArn = exampleAwsIamRole.Arn,
 *         SourceS3Path = new Aws.Kendra.Inputs.ThesaurusSourceS3PathArgs
 *         {
 *             Bucket = exampleAwsS3Bucket.Id,
 *             Key = exampleAwsS3Object.Key,
 *         },
 *         Tags =
 *         {
 *             { "Name", "Example Kendra Thesaurus" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kendra"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kendra.NewThesaurus(ctx, "example", &kendra.ThesaurusArgs{
 * 			IndexId: pulumi.Any(exampleAwsKendraIndex.Id),
 * 			Name:    pulumi.String("Example"),
 * 			RoleArn: pulumi.Any(exampleAwsIamRole.Arn),
 * 			SourceS3Path: &kendra.ThesaurusSourceS3PathArgs{
 * 				Bucket: pulumi.Any(exampleAwsS3Bucket.Id),
 * 				Key:    pulumi.Any(exampleAwsS3Object.Key),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("Example Kendra Thesaurus"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kendra.Thesaurus;
 * import com.pulumi.aws.kendra.ThesaurusArgs;
 * import com.pulumi.aws.kendra.inputs.ThesaurusSourceS3PathArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Thesaurus("example", ThesaurusArgs.builder()
 *             .indexId(exampleAwsKendraIndex.id())
 *             .name("Example")
 *             .roleArn(exampleAwsIamRole.arn())
 *             .sourceS3Path(ThesaurusSourceS3PathArgs.builder()
 *                 .bucket(exampleAwsS3Bucket.id())
 *                 .key(exampleAwsS3Object.key())
 *                 .build())
 *             .tags(Map.of("Name", "Example Kendra Thesaurus"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:kendra:Thesaurus
 *     properties:
 *       indexId: ${exampleAwsKendraIndex.id}
 *       name: Example
 *       roleArn: ${exampleAwsIamRole.arn}
 *       sourceS3Path:
 *         bucket: ${exampleAwsS3Bucket.id}
 *         key: ${exampleAwsS3Object.key}
 *       tags:
 *         Name: Example Kendra Thesaurus
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_kendra_thesaurus` using the unique identifiers of the thesaurus and index separated by a slash (`/`). For example:
 * ```sh
 * $ pulumi import aws:kendra/thesaurus:Thesaurus example thesaurus-123456780/idx-8012925589
 * ```
 * @property description
 * @property indexId The identifier of the index for a thesaurus.
 * @property name The name for the thesaurus.
 * @property roleArn The IAM (Identity and Access Management) role used to access the thesaurus file in S3.
 * @property sourceS3Path The S3 path where your thesaurus file sits in S3. Detailed below.
 * @property tags
 */
public data class ThesaurusArgs(
    public val description: Output<String>? = null,
    public val indexId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val roleArn: Output<String>? = null,
    public val sourceS3Path: Output<ThesaurusSourceS3PathArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.kendra.ThesaurusArgs> {
    override fun toJava(): com.pulumi.aws.kendra.ThesaurusArgs =
        com.pulumi.aws.kendra.ThesaurusArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .indexId(indexId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .sourceS3Path(sourceS3Path?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ThesaurusArgs].
 */
@PulumiTagMarker
public class ThesaurusArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var indexId: Output<String>? = null

    private var name: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var sourceS3Path: Output<ThesaurusSourceS3PathArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value
     */
    @JvmName("rpgkwvkgheialnku")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The identifier of the index for a thesaurus.
     */
    @JvmName("yssepoqfqexcpqfk")
    public suspend fun indexId(`value`: Output<String>) {
        this.indexId = value
    }

    /**
     * @param value The name for the thesaurus.
     */
    @JvmName("hdunegvakdptqhgo")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The IAM (Identity and Access Management) role used to access the thesaurus file in S3.
     */
    @JvmName("cwdrplfkrgfeugjq")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The S3 path where your thesaurus file sits in S3. Detailed below.
     */
    @JvmName("snpdphjhimrlcdsl")
    public suspend fun sourceS3Path(`value`: Output<ThesaurusSourceS3PathArgs>) {
        this.sourceS3Path = value
    }

    /**
     * @param value
     */
    @JvmName("opcjqdpjljpsflpn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("ofqbyochfxibulfo")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The identifier of the index for a thesaurus.
     */
    @JvmName("kuqinvchujuwixnh")
    public suspend fun indexId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.indexId = mapped
    }

    /**
     * @param value The name for the thesaurus.
     */
    @JvmName("ewpemwcgluagyurg")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The IAM (Identity and Access Management) role used to access the thesaurus file in S3.
     */
    @JvmName("mrtfhwfmyuwwevff")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value The S3 path where your thesaurus file sits in S3. Detailed below.
     */
    @JvmName("dtyrxvxuxnatxsmt")
    public suspend fun sourceS3Path(`value`: ThesaurusSourceS3PathArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceS3Path = mapped
    }

    /**
     * @param argument The S3 path where your thesaurus file sits in S3. Detailed below.
     */
    @JvmName("sccqdckumkdetdxf")
    public suspend fun sourceS3Path(argument: suspend ThesaurusSourceS3PathArgsBuilder.() -> Unit) {
        val toBeMapped = ThesaurusSourceS3PathArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceS3Path = mapped
    }

    /**
     * @param value
     */
    @JvmName("jcapbtitnjbiviua")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("gkeqhgyscvgqmekm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ThesaurusArgs = ThesaurusArgs(
        description = description,
        indexId = indexId,
        name = name,
        roleArn = roleArn,
        sourceS3Path = sourceS3Path,
        tags = tags,
    )
}
