@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.inputs

import com.pulumi.aws.kendra.inputs.DataSourceConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property s3Configuration A block that provides the configuration information to connect to an Amazon S3 bucket as your data source. Detailed below.
 * @property webCrawlerConfiguration A block that provides the configuration information required for Amazon Kendra Web Crawler. Detailed below.
 */
public data class DataSourceConfigurationArgs(
    public val s3Configuration: Output<DataSourceConfigurationS3ConfigurationArgs>? = null,
    public val webCrawlerConfiguration: Output<DataSourceConfigurationWebCrawlerConfigurationArgs>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.kendra.inputs.DataSourceConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.kendra.inputs.DataSourceConfigurationArgs =
        com.pulumi.aws.kendra.inputs.DataSourceConfigurationArgs.builder()
            .s3Configuration(s3Configuration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .webCrawlerConfiguration(
                webCrawlerConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DataSourceConfigurationArgs].
 */
@PulumiTagMarker
public class DataSourceConfigurationArgsBuilder internal constructor() {
    private var s3Configuration: Output<DataSourceConfigurationS3ConfigurationArgs>? = null

    private var webCrawlerConfiguration: Output<DataSourceConfigurationWebCrawlerConfigurationArgs>? =
        null

    /**
     * @param value A block that provides the configuration information to connect to an Amazon S3 bucket as your data source. Detailed below.
     */
    @JvmName("anfftpeprhvnrjjt")
    public suspend fun s3Configuration(`value`: Output<DataSourceConfigurationS3ConfigurationArgs>) {
        this.s3Configuration = value
    }

    /**
     * @param value A block that provides the configuration information required for Amazon Kendra Web Crawler. Detailed below.
     */
    @JvmName("awumwjepvnwnjlip")
    public suspend fun webCrawlerConfiguration(`value`: Output<DataSourceConfigurationWebCrawlerConfigurationArgs>) {
        this.webCrawlerConfiguration = value
    }

    /**
     * @param value A block that provides the configuration information to connect to an Amazon S3 bucket as your data source. Detailed below.
     */
    @JvmName("xiugfbmpokkrioou")
    public suspend fun s3Configuration(`value`: DataSourceConfigurationS3ConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Configuration = mapped
    }

    /**
     * @param argument A block that provides the configuration information to connect to an Amazon S3 bucket as your data source. Detailed below.
     */
    @JvmName("vbrswlrxdnmidwka")
    public suspend fun s3Configuration(argument: suspend DataSourceConfigurationS3ConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = DataSourceConfigurationS3ConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.s3Configuration = mapped
    }

    /**
     * @param value A block that provides the configuration information required for Amazon Kendra Web Crawler. Detailed below.
     */
    @JvmName("sxlmrwgalwcdtncy")
    public suspend fun webCrawlerConfiguration(`value`: DataSourceConfigurationWebCrawlerConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webCrawlerConfiguration = mapped
    }

    /**
     * @param argument A block that provides the configuration information required for Amazon Kendra Web Crawler. Detailed below.
     */
    @JvmName("iclptjvoorqhipge")
    public suspend fun webCrawlerConfiguration(argument: suspend DataSourceConfigurationWebCrawlerConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = DataSourceConfigurationWebCrawlerConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.webCrawlerConfiguration = mapped
    }

    internal fun build(): DataSourceConfigurationArgs = DataSourceConfigurationArgs(
        s3Configuration = s3Configuration,
        webCrawlerConfiguration = webCrawlerConfiguration,
    )
}
