@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.inputs

import com.pulumi.aws.kendra.inputs.DataSourceConfigurationS3ConfigurationAccessControlListConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property keyPath Path to the AWS S3 bucket that contains the ACL files.
 */
public data class DataSourceConfigurationS3ConfigurationAccessControlListConfigurationArgs(
    public val keyPath: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.kendra.inputs.DataSourceConfigurationS3ConfigurationAccessControlListConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.kendra.inputs.DataSourceConfigurationS3ConfigurationAccessControlListConfigurationArgs =
        com.pulumi.aws.kendra.inputs.DataSourceConfigurationS3ConfigurationAccessControlListConfigurationArgs.builder()
            .keyPath(keyPath?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSourceConfigurationS3ConfigurationAccessControlListConfigurationArgs].
 */
@PulumiTagMarker
public class DataSourceConfigurationS3ConfigurationAccessControlListConfigurationArgsBuilder
internal constructor() {
    private var keyPath: Output<String>? = null

    /**
     * @param value Path to the AWS S3 bucket that contains the ACL files.
     */
    @JvmName("pnkncfrmtbhjlcmn")
    public suspend fun keyPath(`value`: Output<String>) {
        this.keyPath = value
    }

    /**
     * @param value Path to the AWS S3 bucket that contains the ACL files.
     */
    @JvmName("inlhrnqtnkrhpkve")
    public suspend fun keyPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyPath = mapped
    }

    internal fun build(): DataSourceConfigurationS3ConfigurationAccessControlListConfigurationArgs =
        DataSourceConfigurationS3ConfigurationAccessControlListConfigurationArgs(
            keyPath = keyPath,
        )
}
