@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.inputs

import com.pulumi.aws.kendra.inputs.DataSourceConfigurationS3ConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property accessControlListConfiguration A block that provides the path to the S3 bucket that contains the user context filtering files for the data source. For the format of the file, see [Access control for S3 data sources](https://docs.aws.amazon.com/kendra/latest/dg/s3-acl.html). Detailed below.
 * @property bucketName The name of the bucket that contains the documents.
 * @property documentsMetadataConfiguration A block that defines the Document metadata files that contain information such as the document access control information, source URI, document author, and custom attributes. Each metadata file contains metadata about a single document. Detailed below.
 * @property exclusionPatterns A list of glob patterns for documents that should not be indexed. If a document that matches an inclusion prefix or inclusion pattern also matches an exclusion pattern, the document is not indexed. Refer to [Exclusion Patterns for more examples](https://docs.aws.amazon.com/kendra/latest/dg/API_S3DataSourceConfiguration.html#Kendra-Type-S3DataSourceConfiguration-ExclusionPatterns).
 * @property inclusionPatterns A list of glob patterns for documents that should be indexed. If a document that matches an inclusion pattern also matches an exclusion pattern, the document is not indexed. Refer to [Inclusion Patterns for more examples](https://docs.aws.amazon.com/kendra/latest/dg/API_S3DataSourceConfiguration.html#Kendra-Type-S3DataSourceConfiguration-InclusionPatterns).
 * @property inclusionPrefixes A list of S3 prefixes for the documents that should be included in the index.
 */
public data class DataSourceConfigurationS3ConfigurationArgs(
    public val accessControlListConfiguration: Output<DataSourceConfigurationS3ConfigurationAccessControlListConfigurationArgs>? = null,
    public val bucketName: Output<String>,
    public val documentsMetadataConfiguration: Output<DataSourceConfigurationS3ConfigurationDocumentsMetadataConfigurationArgs>? = null,
    public val exclusionPatterns: Output<List<String>>? = null,
    public val inclusionPatterns: Output<List<String>>? = null,
    public val inclusionPrefixes: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.kendra.inputs.DataSourceConfigurationS3ConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.kendra.inputs.DataSourceConfigurationS3ConfigurationArgs =
        com.pulumi.aws.kendra.inputs.DataSourceConfigurationS3ConfigurationArgs.builder()
            .accessControlListConfiguration(
                accessControlListConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .bucketName(bucketName.applyValue({ args0 -> args0 }))
            .documentsMetadataConfiguration(
                documentsMetadataConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .exclusionPatterns(exclusionPatterns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .inclusionPatterns(inclusionPatterns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .inclusionPrefixes(inclusionPrefixes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [DataSourceConfigurationS3ConfigurationArgs].
 */
@PulumiTagMarker
public class DataSourceConfigurationS3ConfigurationArgsBuilder internal constructor() {
    private var accessControlListConfiguration:
        Output<DataSourceConfigurationS3ConfigurationAccessControlListConfigurationArgs>? = null

    private var bucketName: Output<String>? = null

    private var documentsMetadataConfiguration:
        Output<DataSourceConfigurationS3ConfigurationDocumentsMetadataConfigurationArgs>? = null

    private var exclusionPatterns: Output<List<String>>? = null

    private var inclusionPatterns: Output<List<String>>? = null

    private var inclusionPrefixes: Output<List<String>>? = null

    /**
     * @param value A block that provides the path to the S3 bucket that contains the user context filtering files for the data source. For the format of the file, see [Access control for S3 data sources](https://docs.aws.amazon.com/kendra/latest/dg/s3-acl.html). Detailed below.
     */
    @JvmName("bhygdxakkbuofpeo")
    public suspend fun accessControlListConfiguration(`value`: Output<DataSourceConfigurationS3ConfigurationAccessControlListConfigurationArgs>) {
        this.accessControlListConfiguration = value
    }

    /**
     * @param value The name of the bucket that contains the documents.
     */
    @JvmName("cidwxjecgtwkhuwn")
    public suspend fun bucketName(`value`: Output<String>) {
        this.bucketName = value
    }

    /**
     * @param value A block that defines the Document metadata files that contain information such as the document access control information, source URI, document author, and custom attributes. Each metadata file contains metadata about a single document. Detailed below.
     */
    @JvmName("dgckrqryxlrlllbx")
    public suspend fun documentsMetadataConfiguration(`value`: Output<DataSourceConfigurationS3ConfigurationDocumentsMetadataConfigurationArgs>) {
        this.documentsMetadataConfiguration = value
    }

    /**
     * @param value A list of glob patterns for documents that should not be indexed. If a document that matches an inclusion prefix or inclusion pattern also matches an exclusion pattern, the document is not indexed. Refer to [Exclusion Patterns for more examples](https://docs.aws.amazon.com/kendra/latest/dg/API_S3DataSourceConfiguration.html#Kendra-Type-S3DataSourceConfiguration-ExclusionPatterns).
     */
    @JvmName("qgvcihxwstgxvdqi")
    public suspend fun exclusionPatterns(`value`: Output<List<String>>) {
        this.exclusionPatterns = value
    }

    @JvmName("lexpapgwxpiyuidq")
    public suspend fun exclusionPatterns(vararg values: Output<String>) {
        this.exclusionPatterns = Output.all(values.asList())
    }

    /**
     * @param values A list of glob patterns for documents that should not be indexed. If a document that matches an inclusion prefix or inclusion pattern also matches an exclusion pattern, the document is not indexed. Refer to [Exclusion Patterns for more examples](https://docs.aws.amazon.com/kendra/latest/dg/API_S3DataSourceConfiguration.html#Kendra-Type-S3DataSourceConfiguration-ExclusionPatterns).
     */
    @JvmName("nsbagotdbawgsdiv")
    public suspend fun exclusionPatterns(values: List<Output<String>>) {
        this.exclusionPatterns = Output.all(values)
    }

    /**
     * @param value A list of glob patterns for documents that should be indexed. If a document that matches an inclusion pattern also matches an exclusion pattern, the document is not indexed. Refer to [Inclusion Patterns for more examples](https://docs.aws.amazon.com/kendra/latest/dg/API_S3DataSourceConfiguration.html#Kendra-Type-S3DataSourceConfiguration-InclusionPatterns).
     */
    @JvmName("weyvpkornfbvvdwx")
    public suspend fun inclusionPatterns(`value`: Output<List<String>>) {
        this.inclusionPatterns = value
    }

    @JvmName("xrqhntdcrnpscajf")
    public suspend fun inclusionPatterns(vararg values: Output<String>) {
        this.inclusionPatterns = Output.all(values.asList())
    }

    /**
     * @param values A list of glob patterns for documents that should be indexed. If a document that matches an inclusion pattern also matches an exclusion pattern, the document is not indexed. Refer to [Inclusion Patterns for more examples](https://docs.aws.amazon.com/kendra/latest/dg/API_S3DataSourceConfiguration.html#Kendra-Type-S3DataSourceConfiguration-InclusionPatterns).
     */
    @JvmName("vwlfwvmnnvjwyjgl")
    public suspend fun inclusionPatterns(values: List<Output<String>>) {
        this.inclusionPatterns = Output.all(values)
    }

    /**
     * @param value A list of S3 prefixes for the documents that should be included in the index.
     */
    @JvmName("futjjcmvdwedhdya")
    public suspend fun inclusionPrefixes(`value`: Output<List<String>>) {
        this.inclusionPrefixes = value
    }

    @JvmName("hvaqvauqdwewgftd")
    public suspend fun inclusionPrefixes(vararg values: Output<String>) {
        this.inclusionPrefixes = Output.all(values.asList())
    }

    /**
     * @param values A list of S3 prefixes for the documents that should be included in the index.
     */
    @JvmName("ulbeqdtodlqgucvo")
    public suspend fun inclusionPrefixes(values: List<Output<String>>) {
        this.inclusionPrefixes = Output.all(values)
    }

    /**
     * @param value A block that provides the path to the S3 bucket that contains the user context filtering files for the data source. For the format of the file, see [Access control for S3 data sources](https://docs.aws.amazon.com/kendra/latest/dg/s3-acl.html). Detailed below.
     */
    @JvmName("uoptuindgujkreoj")
    public suspend fun accessControlListConfiguration(`value`: DataSourceConfigurationS3ConfigurationAccessControlListConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessControlListConfiguration = mapped
    }

    /**
     * @param argument A block that provides the path to the S3 bucket that contains the user context filtering files for the data source. For the format of the file, see [Access control for S3 data sources](https://docs.aws.amazon.com/kendra/latest/dg/s3-acl.html). Detailed below.
     */
    @JvmName("pxdxlliwqydikyia")
    public suspend fun accessControlListConfiguration(argument: suspend DataSourceConfigurationS3ConfigurationAccessControlListConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            DataSourceConfigurationS3ConfigurationAccessControlListConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.accessControlListConfiguration = mapped
    }

    /**
     * @param value The name of the bucket that contains the documents.
     */
    @JvmName("eagxqsgidvqfidjq")
    public suspend fun bucketName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucketName = mapped
    }

    /**
     * @param value A block that defines the Document metadata files that contain information such as the document access control information, source URI, document author, and custom attributes. Each metadata file contains metadata about a single document. Detailed below.
     */
    @JvmName("oywallhmkkpxuiuq")
    public suspend fun documentsMetadataConfiguration(`value`: DataSourceConfigurationS3ConfigurationDocumentsMetadataConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.documentsMetadataConfiguration = mapped
    }

    /**
     * @param argument A block that defines the Document metadata files that contain information such as the document access control information, source URI, document author, and custom attributes. Each metadata file contains metadata about a single document. Detailed below.
     */
    @JvmName("hetwwbsnnieuddso")
    public suspend fun documentsMetadataConfiguration(argument: suspend DataSourceConfigurationS3ConfigurationDocumentsMetadataConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            DataSourceConfigurationS3ConfigurationDocumentsMetadataConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.documentsMetadataConfiguration = mapped
    }

    /**
     * @param value A list of glob patterns for documents that should not be indexed. If a document that matches an inclusion prefix or inclusion pattern also matches an exclusion pattern, the document is not indexed. Refer to [Exclusion Patterns for more examples](https://docs.aws.amazon.com/kendra/latest/dg/API_S3DataSourceConfiguration.html#Kendra-Type-S3DataSourceConfiguration-ExclusionPatterns).
     */
    @JvmName("liwyeliiemkvxxgj")
    public suspend fun exclusionPatterns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exclusionPatterns = mapped
    }

    /**
     * @param values A list of glob patterns for documents that should not be indexed. If a document that matches an inclusion prefix or inclusion pattern also matches an exclusion pattern, the document is not indexed. Refer to [Exclusion Patterns for more examples](https://docs.aws.amazon.com/kendra/latest/dg/API_S3DataSourceConfiguration.html#Kendra-Type-S3DataSourceConfiguration-ExclusionPatterns).
     */
    @JvmName("wojpadpghymsrwbh")
    public suspend fun exclusionPatterns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.exclusionPatterns = mapped
    }

    /**
     * @param value A list of glob patterns for documents that should be indexed. If a document that matches an inclusion pattern also matches an exclusion pattern, the document is not indexed. Refer to [Inclusion Patterns for more examples](https://docs.aws.amazon.com/kendra/latest/dg/API_S3DataSourceConfiguration.html#Kendra-Type-S3DataSourceConfiguration-InclusionPatterns).
     */
    @JvmName("ukyybpmmswrqymxu")
    public suspend fun inclusionPatterns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inclusionPatterns = mapped
    }

    /**
     * @param values A list of glob patterns for documents that should be indexed. If a document that matches an inclusion pattern also matches an exclusion pattern, the document is not indexed. Refer to [Inclusion Patterns for more examples](https://docs.aws.amazon.com/kendra/latest/dg/API_S3DataSourceConfiguration.html#Kendra-Type-S3DataSourceConfiguration-InclusionPatterns).
     */
    @JvmName("ifjjufcgkecjlyki")
    public suspend fun inclusionPatterns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inclusionPatterns = mapped
    }

    /**
     * @param value A list of S3 prefixes for the documents that should be included in the index.
     */
    @JvmName("qcmqjhosuvshovkl")
    public suspend fun inclusionPrefixes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inclusionPrefixes = mapped
    }

    /**
     * @param values A list of S3 prefixes for the documents that should be included in the index.
     */
    @JvmName("cmgweewthxsndxoi")
    public suspend fun inclusionPrefixes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inclusionPrefixes = mapped
    }

    internal fun build(): DataSourceConfigurationS3ConfigurationArgs =
        DataSourceConfigurationS3ConfigurationArgs(
            accessControlListConfiguration = accessControlListConfiguration,
            bucketName = bucketName ?: throw PulumiNullFieldException("bucketName"),
            documentsMetadataConfiguration = documentsMetadataConfiguration,
            exclusionPatterns = exclusionPatterns,
            inclusionPatterns = inclusionPatterns,
            inclusionPrefixes = inclusionPrefixes,
        )
}
