@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.inputs

import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property authenticationConfiguration A block with the configuration information required to connect to websites using authentication. You can connect to websites using basic authentication of user name and password. You use a secret in AWS Secrets Manager to store your authentication credentials. You must provide the website host name and port number. For example, the host name of `https://a.example.com/page1.html` is `"a.example.com"` and the port is `443`, the standard port for HTTPS. Detailed below.
 * @property crawlDepth Specifies the number of levels in a website that you want to crawl. The first level begins from the website seed or starting point URL. For example, if a website has 3 levels – index level (i.e. seed in this example), sections level, and subsections level – and you are only interested in crawling information up to the sections level (i.e. levels 0-1), you can set your depth to 1. The default crawl depth is set to `2`. Minimum value of `0`. Maximum value of `10`.
 * @property maxContentSizePerPageInMegaBytes The maximum size (in MB) of a webpage or attachment to crawl. Files larger than this size (in MB) are skipped/not crawled. The default maximum size of a webpage or attachment is set to `50` MB. Minimum value of `1.0e-06`. Maximum value of `50`.
 * @property maxLinksPerPage The maximum number of URLs on a webpage to include when crawling a website. This number is per webpage. As a website’s webpages are crawled, any URLs the webpages link to are also crawled. URLs on a webpage are crawled in order of appearance. The default maximum links per page is `100`. Minimum value of `1`. Maximum value of `1000`.
 * @property maxUrlsPerMinuteCrawlRate The maximum number of URLs crawled per website host per minute. The default maximum number of URLs crawled per website host per minute is `300`. Minimum value of `1`. Maximum value of `300`.
 * @property proxyConfiguration Configuration information required to connect to your internal websites via a web proxy. You must provide the website host name and port number. For example, the host name of `https://a.example.com/page1.html` is `"a.example.com"` and the port is `443`, the standard port for HTTPS. Web proxy credentials are optional and you can use them to connect to a web proxy server that requires basic authentication. To store web proxy credentials, you use a secret in [AWS Secrets Manager](https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html). Detailed below.
 * @property urlExclusionPatterns A list of regular expression patterns to exclude certain URLs to crawl. URLs that match the patterns are excluded from the index. URLs that don't match the patterns are included in the index. If a URL matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the URL file isn't included in the index. Array Members: Minimum number of `0` items. Maximum number of `100` items. Length Constraints: Minimum length of `1`. Maximum length of `150`.
 * @property urlInclusionPatterns A list of regular expression patterns to include certain URLs to crawl. URLs that match the patterns are included in the index. URLs that don't match the patterns are excluded from the index. If a URL matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the URL file isn't included in the index. Array Members: Minimum number of `0` items. Maximum number of `100` items. Length Constraints: Minimum length of `1`. Maximum length of `150`.
 * @property urls A block that specifies the seed or starting point URLs of the websites or the sitemap URLs of the websites you want to crawl. You can include website subdomains. You can list up to `100` seed URLs and up to `3` sitemap URLs. You can only crawl websites that use the secure communication protocol, Hypertext Transfer Protocol Secure (HTTPS). If you receive an error when crawling a website, it could be that the website is blocked from crawling. When selecting websites to index, you must adhere to the [Amazon Acceptable Use Policy](https://aws.amazon.com/aup/) and all other Amazon terms. Remember that you must only use Amazon Kendra Web Crawler to index your own webpages, or webpages that you have authorization to index. Detailed below.
 */
public data class DataSourceConfigurationWebCrawlerConfigurationArgs(
    public val authenticationConfiguration: Output<DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfigurationArgs>? = null,
    public val crawlDepth: Output<Int>? = null,
    public val maxContentSizePerPageInMegaBytes: Output<Double>? = null,
    public val maxLinksPerPage: Output<Int>? = null,
    public val maxUrlsPerMinuteCrawlRate: Output<Int>? = null,
    public val proxyConfiguration: Output<DataSourceConfigurationWebCrawlerConfigurationProxyConfigurationArgs>? = null,
    public val urlExclusionPatterns: Output<List<String>>? = null,
    public val urlInclusionPatterns: Output<List<String>>? = null,
    public val urls: Output<DataSourceConfigurationWebCrawlerConfigurationUrlsArgs>,
) :
    ConvertibleToJava<com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationArgs =
        com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationArgs.builder()
            .authenticationConfiguration(
                authenticationConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .crawlDepth(crawlDepth?.applyValue({ args0 -> args0 }))
            .maxContentSizePerPageInMegaBytes(maxContentSizePerPageInMegaBytes?.applyValue({ args0 -> args0 }))
            .maxLinksPerPage(maxLinksPerPage?.applyValue({ args0 -> args0 }))
            .maxUrlsPerMinuteCrawlRate(maxUrlsPerMinuteCrawlRate?.applyValue({ args0 -> args0 }))
            .proxyConfiguration(
                proxyConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .urlExclusionPatterns(urlExclusionPatterns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .urlInclusionPatterns(urlInclusionPatterns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .urls(urls.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DataSourceConfigurationWebCrawlerConfigurationArgs].
 */
@PulumiTagMarker
public class DataSourceConfigurationWebCrawlerConfigurationArgsBuilder internal constructor() {
    private var authenticationConfiguration:
        Output<DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfigurationArgs>? = null

    private var crawlDepth: Output<Int>? = null

    private var maxContentSizePerPageInMegaBytes: Output<Double>? = null

    private var maxLinksPerPage: Output<Int>? = null

    private var maxUrlsPerMinuteCrawlRate: Output<Int>? = null

    private var proxyConfiguration:
        Output<DataSourceConfigurationWebCrawlerConfigurationProxyConfigurationArgs>? = null

    private var urlExclusionPatterns: Output<List<String>>? = null

    private var urlInclusionPatterns: Output<List<String>>? = null

    private var urls: Output<DataSourceConfigurationWebCrawlerConfigurationUrlsArgs>? = null

    /**
     * @param value A block with the configuration information required to connect to websites using authentication. You can connect to websites using basic authentication of user name and password. You use a secret in AWS Secrets Manager to store your authentication credentials. You must provide the website host name and port number. For example, the host name of `https://a.example.com/page1.html` is `"a.example.com"` and the port is `443`, the standard port for HTTPS. Detailed below.
     */
    @JvmName("kvcbcpvguqsbnmtq")
    public suspend fun authenticationConfiguration(`value`: Output<DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfigurationArgs>) {
        this.authenticationConfiguration = value
    }

    /**
     * @param value Specifies the number of levels in a website that you want to crawl. The first level begins from the website seed or starting point URL. For example, if a website has 3 levels – index level (i.e. seed in this example), sections level, and subsections level – and you are only interested in crawling information up to the sections level (i.e. levels 0-1), you can set your depth to 1. The default crawl depth is set to `2`. Minimum value of `0`. Maximum value of `10`.
     */
    @JvmName("prabbhimlnoyggyc")
    public suspend fun crawlDepth(`value`: Output<Int>) {
        this.crawlDepth = value
    }

    /**
     * @param value The maximum size (in MB) of a webpage or attachment to crawl. Files larger than this size (in MB) are skipped/not crawled. The default maximum size of a webpage or attachment is set to `50` MB. Minimum value of `1.0e-06`. Maximum value of `50`.
     */
    @JvmName("wdsossfcacvftfjc")
    public suspend fun maxContentSizePerPageInMegaBytes(`value`: Output<Double>) {
        this.maxContentSizePerPageInMegaBytes = value
    }

    /**
     * @param value The maximum number of URLs on a webpage to include when crawling a website. This number is per webpage. As a website’s webpages are crawled, any URLs the webpages link to are also crawled. URLs on a webpage are crawled in order of appearance. The default maximum links per page is `100`. Minimum value of `1`. Maximum value of `1000`.
     */
    @JvmName("rqpmdyerqmlycixf")
    public suspend fun maxLinksPerPage(`value`: Output<Int>) {
        this.maxLinksPerPage = value
    }

    /**
     * @param value The maximum number of URLs crawled per website host per minute. The default maximum number of URLs crawled per website host per minute is `300`. Minimum value of `1`. Maximum value of `300`.
     */
    @JvmName("yxtwvqrfsxstcqne")
    public suspend fun maxUrlsPerMinuteCrawlRate(`value`: Output<Int>) {
        this.maxUrlsPerMinuteCrawlRate = value
    }

    /**
     * @param value Configuration information required to connect to your internal websites via a web proxy. You must provide the website host name and port number. For example, the host name of `https://a.example.com/page1.html` is `"a.example.com"` and the port is `443`, the standard port for HTTPS. Web proxy credentials are optional and you can use them to connect to a web proxy server that requires basic authentication. To store web proxy credentials, you use a secret in [AWS Secrets Manager](https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html). Detailed below.
     */
    @JvmName("rgvrrkjmbpyfjfvy")
    public suspend fun proxyConfiguration(`value`: Output<DataSourceConfigurationWebCrawlerConfigurationProxyConfigurationArgs>) {
        this.proxyConfiguration = value
    }

    /**
     * @param value A list of regular expression patterns to exclude certain URLs to crawl. URLs that match the patterns are excluded from the index. URLs that don't match the patterns are included in the index. If a URL matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the URL file isn't included in the index. Array Members: Minimum number of `0` items. Maximum number of `100` items. Length Constraints: Minimum length of `1`. Maximum length of `150`.
     */
    @JvmName("tksoidbljpwbdijb")
    public suspend fun urlExclusionPatterns(`value`: Output<List<String>>) {
        this.urlExclusionPatterns = value
    }

    @JvmName("mvrefqvpwnngijic")
    public suspend fun urlExclusionPatterns(vararg values: Output<String>) {
        this.urlExclusionPatterns = Output.all(values.asList())
    }

    /**
     * @param values A list of regular expression patterns to exclude certain URLs to crawl. URLs that match the patterns are excluded from the index. URLs that don't match the patterns are included in the index. If a URL matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the URL file isn't included in the index. Array Members: Minimum number of `0` items. Maximum number of `100` items. Length Constraints: Minimum length of `1`. Maximum length of `150`.
     */
    @JvmName("hscbjfovjexcemxu")
    public suspend fun urlExclusionPatterns(values: List<Output<String>>) {
        this.urlExclusionPatterns = Output.all(values)
    }

    /**
     * @param value A list of regular expression patterns to include certain URLs to crawl. URLs that match the patterns are included in the index. URLs that don't match the patterns are excluded from the index. If a URL matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the URL file isn't included in the index. Array Members: Minimum number of `0` items. Maximum number of `100` items. Length Constraints: Minimum length of `1`. Maximum length of `150`.
     */
    @JvmName("hrogrrsobwtplhln")
    public suspend fun urlInclusionPatterns(`value`: Output<List<String>>) {
        this.urlInclusionPatterns = value
    }

    @JvmName("whwiflfpxwiutrsw")
    public suspend fun urlInclusionPatterns(vararg values: Output<String>) {
        this.urlInclusionPatterns = Output.all(values.asList())
    }

    /**
     * @param values A list of regular expression patterns to include certain URLs to crawl. URLs that match the patterns are included in the index. URLs that don't match the patterns are excluded from the index. If a URL matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the URL file isn't included in the index. Array Members: Minimum number of `0` items. Maximum number of `100` items. Length Constraints: Minimum length of `1`. Maximum length of `150`.
     */
    @JvmName("gtmkycbktgmhcivh")
    public suspend fun urlInclusionPatterns(values: List<Output<String>>) {
        this.urlInclusionPatterns = Output.all(values)
    }

    /**
     * @param value A block that specifies the seed or starting point URLs of the websites or the sitemap URLs of the websites you want to crawl. You can include website subdomains. You can list up to `100` seed URLs and up to `3` sitemap URLs. You can only crawl websites that use the secure communication protocol, Hypertext Transfer Protocol Secure (HTTPS). If you receive an error when crawling a website, it could be that the website is blocked from crawling. When selecting websites to index, you must adhere to the [Amazon Acceptable Use Policy](https://aws.amazon.com/aup/) and all other Amazon terms. Remember that you must only use Amazon Kendra Web Crawler to index your own webpages, or webpages that you have authorization to index. Detailed below.
     */
    @JvmName("jxojiqbhthuygvlo")
    public suspend fun urls(`value`: Output<DataSourceConfigurationWebCrawlerConfigurationUrlsArgs>) {
        this.urls = value
    }

    /**
     * @param value A block with the configuration information required to connect to websites using authentication. You can connect to websites using basic authentication of user name and password. You use a secret in AWS Secrets Manager to store your authentication credentials. You must provide the website host name and port number. For example, the host name of `https://a.example.com/page1.html` is `"a.example.com"` and the port is `443`, the standard port for HTTPS. Detailed below.
     */
    @JvmName("uxfhspitecixewqf")
    public suspend fun authenticationConfiguration(`value`: DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationConfiguration = mapped
    }

    /**
     * @param argument A block with the configuration information required to connect to websites using authentication. You can connect to websites using basic authentication of user name and password. You use a secret in AWS Secrets Manager to store your authentication credentials. You must provide the website host name and port number. For example, the host name of `https://a.example.com/page1.html` is `"a.example.com"` and the port is `443`, the standard port for HTTPS. Detailed below.
     */
    @JvmName("ocxsngfgaunyfdgm")
    public suspend fun authenticationConfiguration(argument: suspend DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.authenticationConfiguration = mapped
    }

    /**
     * @param value Specifies the number of levels in a website that you want to crawl. The first level begins from the website seed or starting point URL. For example, if a website has 3 levels – index level (i.e. seed in this example), sections level, and subsections level – and you are only interested in crawling information up to the sections level (i.e. levels 0-1), you can set your depth to 1. The default crawl depth is set to `2`. Minimum value of `0`. Maximum value of `10`.
     */
    @JvmName("mpvlirefeisnjciw")
    public suspend fun crawlDepth(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.crawlDepth = mapped
    }

    /**
     * @param value The maximum size (in MB) of a webpage or attachment to crawl. Files larger than this size (in MB) are skipped/not crawled. The default maximum size of a webpage or attachment is set to `50` MB. Minimum value of `1.0e-06`. Maximum value of `50`.
     */
    @JvmName("gjvsyomiinxnfqfo")
    public suspend fun maxContentSizePerPageInMegaBytes(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxContentSizePerPageInMegaBytes = mapped
    }

    /**
     * @param value The maximum number of URLs on a webpage to include when crawling a website. This number is per webpage. As a website’s webpages are crawled, any URLs the webpages link to are also crawled. URLs on a webpage are crawled in order of appearance. The default maximum links per page is `100`. Minimum value of `1`. Maximum value of `1000`.
     */
    @JvmName("terxtsnnpnaxmqgx")
    public suspend fun maxLinksPerPage(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxLinksPerPage = mapped
    }

    /**
     * @param value The maximum number of URLs crawled per website host per minute. The default maximum number of URLs crawled per website host per minute is `300`. Minimum value of `1`. Maximum value of `300`.
     */
    @JvmName("ywpsilskwlfhqqkd")
    public suspend fun maxUrlsPerMinuteCrawlRate(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxUrlsPerMinuteCrawlRate = mapped
    }

    /**
     * @param value Configuration information required to connect to your internal websites via a web proxy. You must provide the website host name and port number. For example, the host name of `https://a.example.com/page1.html` is `"a.example.com"` and the port is `443`, the standard port for HTTPS. Web proxy credentials are optional and you can use them to connect to a web proxy server that requires basic authentication. To store web proxy credentials, you use a secret in [AWS Secrets Manager](https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html). Detailed below.
     */
    @JvmName("jtvdyxchlnltwitt")
    public suspend fun proxyConfiguration(`value`: DataSourceConfigurationWebCrawlerConfigurationProxyConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.proxyConfiguration = mapped
    }

    /**
     * @param argument Configuration information required to connect to your internal websites via a web proxy. You must provide the website host name and port number. For example, the host name of `https://a.example.com/page1.html` is `"a.example.com"` and the port is `443`, the standard port for HTTPS. Web proxy credentials are optional and you can use them to connect to a web proxy server that requires basic authentication. To store web proxy credentials, you use a secret in [AWS Secrets Manager](https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html). Detailed below.
     */
    @JvmName("hpxjwaonmjfrexev")
    public suspend fun proxyConfiguration(argument: suspend DataSourceConfigurationWebCrawlerConfigurationProxyConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            DataSourceConfigurationWebCrawlerConfigurationProxyConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.proxyConfiguration = mapped
    }

    /**
     * @param value A list of regular expression patterns to exclude certain URLs to crawl. URLs that match the patterns are excluded from the index. URLs that don't match the patterns are included in the index. If a URL matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the URL file isn't included in the index. Array Members: Minimum number of `0` items. Maximum number of `100` items. Length Constraints: Minimum length of `1`. Maximum length of `150`.
     */
    @JvmName("vxlufchsibqopuax")
    public suspend fun urlExclusionPatterns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.urlExclusionPatterns = mapped
    }

    /**
     * @param values A list of regular expression patterns to exclude certain URLs to crawl. URLs that match the patterns are excluded from the index. URLs that don't match the patterns are included in the index. If a URL matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the URL file isn't included in the index. Array Members: Minimum number of `0` items. Maximum number of `100` items. Length Constraints: Minimum length of `1`. Maximum length of `150`.
     */
    @JvmName("omgefsgltxyrnedo")
    public suspend fun urlExclusionPatterns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.urlExclusionPatterns = mapped
    }

    /**
     * @param value A list of regular expression patterns to include certain URLs to crawl. URLs that match the patterns are included in the index. URLs that don't match the patterns are excluded from the index. If a URL matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the URL file isn't included in the index. Array Members: Minimum number of `0` items. Maximum number of `100` items. Length Constraints: Minimum length of `1`. Maximum length of `150`.
     */
    @JvmName("sqkbueekgrofyvog")
    public suspend fun urlInclusionPatterns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.urlInclusionPatterns = mapped
    }

    /**
     * @param values A list of regular expression patterns to include certain URLs to crawl. URLs that match the patterns are included in the index. URLs that don't match the patterns are excluded from the index. If a URL matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the URL file isn't included in the index. Array Members: Minimum number of `0` items. Maximum number of `100` items. Length Constraints: Minimum length of `1`. Maximum length of `150`.
     */
    @JvmName("lxshynaldbrcrxuc")
    public suspend fun urlInclusionPatterns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.urlInclusionPatterns = mapped
    }

    /**
     * @param value A block that specifies the seed or starting point URLs of the websites or the sitemap URLs of the websites you want to crawl. You can include website subdomains. You can list up to `100` seed URLs and up to `3` sitemap URLs. You can only crawl websites that use the secure communication protocol, Hypertext Transfer Protocol Secure (HTTPS). If you receive an error when crawling a website, it could be that the website is blocked from crawling. When selecting websites to index, you must adhere to the [Amazon Acceptable Use Policy](https://aws.amazon.com/aup/) and all other Amazon terms. Remember that you must only use Amazon Kendra Web Crawler to index your own webpages, or webpages that you have authorization to index. Detailed below.
     */
    @JvmName("nabdunmyowwchgcm")
    public suspend fun urls(`value`: DataSourceConfigurationWebCrawlerConfigurationUrlsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.urls = mapped
    }

    /**
     * @param argument A block that specifies the seed or starting point URLs of the websites or the sitemap URLs of the websites you want to crawl. You can include website subdomains. You can list up to `100` seed URLs and up to `3` sitemap URLs. You can only crawl websites that use the secure communication protocol, Hypertext Transfer Protocol Secure (HTTPS). If you receive an error when crawling a website, it could be that the website is blocked from crawling. When selecting websites to index, you must adhere to the [Amazon Acceptable Use Policy](https://aws.amazon.com/aup/) and all other Amazon terms. Remember that you must only use Amazon Kendra Web Crawler to index your own webpages, or webpages that you have authorization to index. Detailed below.
     */
    @JvmName("mgbqufstlqqqsste")
    public suspend fun urls(argument: suspend DataSourceConfigurationWebCrawlerConfigurationUrlsArgsBuilder.() -> Unit) {
        val toBeMapped = DataSourceConfigurationWebCrawlerConfigurationUrlsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.urls = mapped
    }

    internal fun build(): DataSourceConfigurationWebCrawlerConfigurationArgs =
        DataSourceConfigurationWebCrawlerConfigurationArgs(
            authenticationConfiguration = authenticationConfiguration,
            crawlDepth = crawlDepth,
            maxContentSizePerPageInMegaBytes = maxContentSizePerPageInMegaBytes,
            maxLinksPerPage = maxLinksPerPage,
            maxUrlsPerMinuteCrawlRate = maxUrlsPerMinuteCrawlRate,
            proxyConfiguration = proxyConfiguration,
            urlExclusionPatterns = urlExclusionPatterns,
            urlInclusionPatterns = urlInclusionPatterns,
            urls = urls ?: throw PulumiNullFieldException("urls"),
        )
}
