@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.inputs

import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfigurationBasicAuthenticationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property credentials Your secret ARN, which you can create in AWS Secrets Manager. You use a secret if basic authentication credentials are required to connect to a website. The secret stores your credentials of user name and password.
 * @property host The name of the website host you want to connect to using authentication credentials. For example, the host name of `https://a.example.com/page1.html` is `"a.example.com"`.
 * @property port The port number of the website host you want to connect to using authentication credentials. For example, the port for `https://a.example.com/page1.html` is `443`, the standard port for HTTPS.
 */
public data class
DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfigurationBasicAuthenticationArgs(
    public val credentials: Output<String>,
    public val host: Output<String>,
    public val port: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfigurationBasicAuthenticationArgs> {
    override fun toJava(): com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfigurationBasicAuthenticationArgs =
        com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfigurationBasicAuthenticationArgs.builder()
            .credentials(credentials.applyValue({ args0 -> args0 }))
            .host(host.applyValue({ args0 -> args0 }))
            .port(port.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfigurationBasicAuthenticationArgs].
 */
@PulumiTagMarker
public class
DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfigurationBasicAuthenticationArgsBuilder
internal constructor() {
    private var credentials: Output<String>? = null

    private var host: Output<String>? = null

    private var port: Output<Int>? = null

    /**
     * @param value Your secret ARN, which you can create in AWS Secrets Manager. You use a secret if basic authentication credentials are required to connect to a website. The secret stores your credentials of user name and password.
     */
    @JvmName("jqspotdlclfopyti")
    public suspend fun credentials(`value`: Output<String>) {
        this.credentials = value
    }

    /**
     * @param value The name of the website host you want to connect to using authentication credentials. For example, the host name of `https://a.example.com/page1.html` is `"a.example.com"`.
     */
    @JvmName("aaanfrmwjcoimxnx")
    public suspend fun host(`value`: Output<String>) {
        this.host = value
    }

    /**
     * @param value The port number of the website host you want to connect to using authentication credentials. For example, the port for `https://a.example.com/page1.html` is `443`, the standard port for HTTPS.
     */
    @JvmName("groigfksduabuopm")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value Your secret ARN, which you can create in AWS Secrets Manager. You use a secret if basic authentication credentials are required to connect to a website. The secret stores your credentials of user name and password.
     */
    @JvmName("rpiqggunelvckldx")
    public suspend fun credentials(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.credentials = mapped
    }

    /**
     * @param value The name of the website host you want to connect to using authentication credentials. For example, the host name of `https://a.example.com/page1.html` is `"a.example.com"`.
     */
    @JvmName("owpqqvhgqecgbgci")
    public suspend fun host(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.host = mapped
    }

    /**
     * @param value The port number of the website host you want to connect to using authentication credentials. For example, the port for `https://a.example.com/page1.html` is `443`, the standard port for HTTPS.
     */
    @JvmName("omdgkkxlidulingq")
    public suspend fun port(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.port = mapped
    }

    internal fun build(): DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfigurationBasicAuthenticationArgs =
        DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfigurationBasicAuthenticationArgs(
            credentials = credentials ?: throw PulumiNullFieldException("credentials"),
            host = host ?: throw PulumiNullFieldException("host"),
            port = port ?: throw PulumiNullFieldException("port"),
        )
}
