@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.inputs

import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationProxyConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property credentials Your secret ARN, which you can create in AWS Secrets Manager. The credentials are optional. You use a secret if web proxy credentials are required to connect to a website host. Amazon Kendra currently support basic authentication to connect to a web proxy server. The secret stores your credentials.
 * @property host The name of the website host you want to connect to via a web proxy server. For example, the host name of `https://a.example.com/page1.html` is `"a.example.com"`.
 * @property port The port number of the website host you want to connect to via a web proxy server. For example, the port for `https://a.example.com/page1.html` is `443`, the standard port for HTTPS.
 */
public data class DataSourceConfigurationWebCrawlerConfigurationProxyConfigurationArgs(
    public val credentials: Output<String>? = null,
    public val host: Output<String>,
    public val port: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationProxyConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationProxyConfigurationArgs =
        com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationProxyConfigurationArgs.builder()
            .credentials(credentials?.applyValue({ args0 -> args0 }))
            .host(host.applyValue({ args0 -> args0 }))
            .port(port.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSourceConfigurationWebCrawlerConfigurationProxyConfigurationArgs].
 */
@PulumiTagMarker
public class DataSourceConfigurationWebCrawlerConfigurationProxyConfigurationArgsBuilder internal constructor() {
    private var credentials: Output<String>? = null

    private var host: Output<String>? = null

    private var port: Output<Int>? = null

    /**
     * @param value Your secret ARN, which you can create in AWS Secrets Manager. The credentials are optional. You use a secret if web proxy credentials are required to connect to a website host. Amazon Kendra currently support basic authentication to connect to a web proxy server. The secret stores your credentials.
     */
    @JvmName("rnqtjkmougshljuv")
    public suspend fun credentials(`value`: Output<String>) {
        this.credentials = value
    }

    /**
     * @param value The name of the website host you want to connect to via a web proxy server. For example, the host name of `https://a.example.com/page1.html` is `"a.example.com"`.
     */
    @JvmName("aqviqwjnnlswthoo")
    public suspend fun host(`value`: Output<String>) {
        this.host = value
    }

    /**
     * @param value The port number of the website host you want to connect to via a web proxy server. For example, the port for `https://a.example.com/page1.html` is `443`, the standard port for HTTPS.
     */
    @JvmName("xnfufcjdgbniitcl")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value Your secret ARN, which you can create in AWS Secrets Manager. The credentials are optional. You use a secret if web proxy credentials are required to connect to a website host. Amazon Kendra currently support basic authentication to connect to a web proxy server. The secret stores your credentials.
     */
    @JvmName("itryocbhccxrllud")
    public suspend fun credentials(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credentials = mapped
    }

    /**
     * @param value The name of the website host you want to connect to via a web proxy server. For example, the host name of `https://a.example.com/page1.html` is `"a.example.com"`.
     */
    @JvmName("ufuqfxntwvynmyla")
    public suspend fun host(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.host = mapped
    }

    /**
     * @param value The port number of the website host you want to connect to via a web proxy server. For example, the port for `https://a.example.com/page1.html` is `443`, the standard port for HTTPS.
     */
    @JvmName("jgcqovbdpdkwtlqo")
    public suspend fun port(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.port = mapped
    }

    internal fun build(): DataSourceConfigurationWebCrawlerConfigurationProxyConfigurationArgs =
        DataSourceConfigurationWebCrawlerConfigurationProxyConfigurationArgs(
            credentials = credentials,
            host = host ?: throw PulumiNullFieldException("host"),
            port = port ?: throw PulumiNullFieldException("port"),
        )
}
