@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.inputs

import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationUrlsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property seedUrlConfiguration A block that specifies the configuration of the seed or starting point URLs of the websites you want to crawl. You can choose to crawl only the website host names, or the website host names with subdomains, or the website host names with subdomains and other domains that the webpages link to. You can list up to `100` seed URLs. Detailed below.
 * @property siteMapsConfiguration A block that specifies the configuration of the sitemap URLs of the websites you want to crawl. Only URLs belonging to the same website host names are crawled. You can list up to `3` sitemap URLs. Detailed below.
 */
public data class DataSourceConfigurationWebCrawlerConfigurationUrlsArgs(
    public val seedUrlConfiguration: Output<DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfigurationArgs>? = null,
    public val siteMapsConfiguration: Output<DataSourceConfigurationWebCrawlerConfigurationUrlsSiteMapsConfigurationArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationUrlsArgs> {
    override fun toJava(): com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationUrlsArgs =
        com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationUrlsArgs.builder()
            .seedUrlConfiguration(
                seedUrlConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .siteMapsConfiguration(
                siteMapsConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DataSourceConfigurationWebCrawlerConfigurationUrlsArgs].
 */
@PulumiTagMarker
public class DataSourceConfigurationWebCrawlerConfigurationUrlsArgsBuilder internal constructor() {
    private var seedUrlConfiguration:
        Output<DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfigurationArgs>? = null

    private var siteMapsConfiguration:
        Output<DataSourceConfigurationWebCrawlerConfigurationUrlsSiteMapsConfigurationArgs>? = null

    /**
     * @param value A block that specifies the configuration of the seed or starting point URLs of the websites you want to crawl. You can choose to crawl only the website host names, or the website host names with subdomains, or the website host names with subdomains and other domains that the webpages link to. You can list up to `100` seed URLs. Detailed below.
     */
    @JvmName("rmpwfelsxranetrf")
    public suspend fun seedUrlConfiguration(`value`: Output<DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfigurationArgs>) {
        this.seedUrlConfiguration = value
    }

    /**
     * @param value A block that specifies the configuration of the sitemap URLs of the websites you want to crawl. Only URLs belonging to the same website host names are crawled. You can list up to `3` sitemap URLs. Detailed below.
     */
    @JvmName("eodhqjebtpsysrgy")
    public suspend fun siteMapsConfiguration(`value`: Output<DataSourceConfigurationWebCrawlerConfigurationUrlsSiteMapsConfigurationArgs>) {
        this.siteMapsConfiguration = value
    }

    /**
     * @param value A block that specifies the configuration of the seed or starting point URLs of the websites you want to crawl. You can choose to crawl only the website host names, or the website host names with subdomains, or the website host names with subdomains and other domains that the webpages link to. You can list up to `100` seed URLs. Detailed below.
     */
    @JvmName("urmqdellbkdbfrok")
    public suspend fun seedUrlConfiguration(`value`: DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.seedUrlConfiguration = mapped
    }

    /**
     * @param argument A block that specifies the configuration of the seed or starting point URLs of the websites you want to crawl. You can choose to crawl only the website host names, or the website host names with subdomains, or the website host names with subdomains and other domains that the webpages link to. You can list up to `100` seed URLs. Detailed below.
     */
    @JvmName("hxsasnymdeanjlmw")
    public suspend fun seedUrlConfiguration(argument: suspend DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.seedUrlConfiguration = mapped
    }

    /**
     * @param value A block that specifies the configuration of the sitemap URLs of the websites you want to crawl. Only URLs belonging to the same website host names are crawled. You can list up to `3` sitemap URLs. Detailed below.
     */
    @JvmName("dqcbvmsqtqeqiray")
    public suspend fun siteMapsConfiguration(`value`: DataSourceConfigurationWebCrawlerConfigurationUrlsSiteMapsConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.siteMapsConfiguration = mapped
    }

    /**
     * @param argument A block that specifies the configuration of the sitemap URLs of the websites you want to crawl. Only URLs belonging to the same website host names are crawled. You can list up to `3` sitemap URLs. Detailed below.
     */
    @JvmName("pumiocgwtbcruoap")
    public suspend fun siteMapsConfiguration(argument: suspend DataSourceConfigurationWebCrawlerConfigurationUrlsSiteMapsConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            DataSourceConfigurationWebCrawlerConfigurationUrlsSiteMapsConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.siteMapsConfiguration = mapped
    }

    internal fun build(): DataSourceConfigurationWebCrawlerConfigurationUrlsArgs =
        DataSourceConfigurationWebCrawlerConfigurationUrlsArgs(
            seedUrlConfiguration = seedUrlConfiguration,
            siteMapsConfiguration = siteMapsConfiguration,
        )
}
