@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.inputs

import com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationUrlsSiteMapsConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property siteMaps The list of sitemap URLs of the websites you want to crawl. The list can include a maximum of `3` sitemap URLs.
 */
public data class DataSourceConfigurationWebCrawlerConfigurationUrlsSiteMapsConfigurationArgs(
    public val siteMaps: Output<List<String>>,
) :
    ConvertibleToJava<com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationUrlsSiteMapsConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationUrlsSiteMapsConfigurationArgs =
        com.pulumi.aws.kendra.inputs.DataSourceConfigurationWebCrawlerConfigurationUrlsSiteMapsConfigurationArgs.builder()
            .siteMaps(siteMaps.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [DataSourceConfigurationWebCrawlerConfigurationUrlsSiteMapsConfigurationArgs].
 */
@PulumiTagMarker
public class DataSourceConfigurationWebCrawlerConfigurationUrlsSiteMapsConfigurationArgsBuilder
internal constructor() {
    private var siteMaps: Output<List<String>>? = null

    /**
     * @param value The list of sitemap URLs of the websites you want to crawl. The list can include a maximum of `3` sitemap URLs.
     */
    @JvmName("nkoqnhlkfwcsumsu")
    public suspend fun siteMaps(`value`: Output<List<String>>) {
        this.siteMaps = value
    }

    @JvmName("qyibwfsnxidmsnqv")
    public suspend fun siteMaps(vararg values: Output<String>) {
        this.siteMaps = Output.all(values.asList())
    }

    /**
     * @param values The list of sitemap URLs of the websites you want to crawl. The list can include a maximum of `3` sitemap URLs.
     */
    @JvmName("cplvqpemuwhjcdrr")
    public suspend fun siteMaps(values: List<Output<String>>) {
        this.siteMaps = Output.all(values)
    }

    /**
     * @param value The list of sitemap URLs of the websites you want to crawl. The list can include a maximum of `3` sitemap URLs.
     */
    @JvmName("eohsfflphpiikcuc")
    public suspend fun siteMaps(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.siteMaps = mapped
    }

    /**
     * @param values The list of sitemap URLs of the websites you want to crawl. The list can include a maximum of `3` sitemap URLs.
     */
    @JvmName("dhyggwdwjvcwknyr")
    public suspend fun siteMaps(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.siteMaps = mapped
    }

    internal fun build(): DataSourceConfigurationWebCrawlerConfigurationUrlsSiteMapsConfigurationArgs = DataSourceConfigurationWebCrawlerConfigurationUrlsSiteMapsConfigurationArgs(
        siteMaps = siteMaps ?: throw PulumiNullFieldException("siteMaps"),
    )
}
