@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.inputs

import com.pulumi.aws.kendra.inputs.DataSourceCustomDocumentEnrichmentConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property inlineConfigurations Configuration information to alter document attributes or metadata fields and content when ingesting documents into Amazon Kendra. Minimum number of `0` items. Maximum number of `100` items. Detailed below.
 * @property postExtractionHookConfiguration A block that specifies the configuration information for invoking a Lambda function in AWS Lambda on the structured documents with their metadata and text extracted. You can use a Lambda function to apply advanced logic for creating, modifying, or deleting document metadata and content. For more information, see [Advanced data manipulation](https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#advanced-data-manipulation). Detailed below.
 * @property preExtractionHookConfiguration Configuration information for invoking a Lambda function in AWS Lambda on the original or raw documents before extracting their metadata and text. You can use a Lambda function to apply advanced logic for creating, modifying, or deleting document metadata and content. For more information, see [Advanced data manipulation](https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#advanced-data-manipulation). Detailed below.
 * @property roleArn The Amazon Resource Name (ARN) of a role with permission to run `pre_extraction_hook_configuration` and `post_extraction_hook_configuration` for altering document metadata and content during the document ingestion process. For more information, see [IAM roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
 */
public data class DataSourceCustomDocumentEnrichmentConfigurationArgs(
    public val inlineConfigurations: Output<List<DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationArgs>>? = null,
    public val postExtractionHookConfiguration: Output<DataSourceCustomDocumentEnrichmentConfigurationPostExtractionHookConfigurationArgs>? =
        null,
    public val preExtractionHookConfiguration: Output<DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationArgs>? =
        null,
    public val roleArn: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.kendra.inputs.DataSourceCustomDocumentEnrichmentConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.kendra.inputs.DataSourceCustomDocumentEnrichmentConfigurationArgs =
        com.pulumi.aws.kendra.inputs.DataSourceCustomDocumentEnrichmentConfigurationArgs.builder()
            .inlineConfigurations(
                inlineConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .postExtractionHookConfiguration(
                postExtractionHookConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .preExtractionHookConfiguration(
                preExtractionHookConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .roleArn(roleArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSourceCustomDocumentEnrichmentConfigurationArgs].
 */
@PulumiTagMarker
public class DataSourceCustomDocumentEnrichmentConfigurationArgsBuilder internal constructor() {
    private var inlineConfigurations:
        Output<List<DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationArgs>>? = null

    private var postExtractionHookConfiguration:
        Output<DataSourceCustomDocumentEnrichmentConfigurationPostExtractionHookConfigurationArgs>? =
        null

    private var preExtractionHookConfiguration:
        Output<DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationArgs>? =
        null

    private var roleArn: Output<String>? = null

    /**
     * @param value Configuration information to alter document attributes or metadata fields and content when ingesting documents into Amazon Kendra. Minimum number of `0` items. Maximum number of `100` items. Detailed below.
     */
    @JvmName("qqorxpwptxvvmnpf")
    public suspend fun inlineConfigurations(`value`: Output<List<DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationArgs>>) {
        this.inlineConfigurations = value
    }

    @JvmName("dirmtpuctfnolejl")
    public suspend fun inlineConfigurations(vararg values: Output<DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationArgs>) {
        this.inlineConfigurations = Output.all(values.asList())
    }

    /**
     * @param values Configuration information to alter document attributes or metadata fields and content when ingesting documents into Amazon Kendra. Minimum number of `0` items. Maximum number of `100` items. Detailed below.
     */
    @JvmName("imdiraiyefewtdda")
    public suspend fun inlineConfigurations(values: List<Output<DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationArgs>>) {
        this.inlineConfigurations = Output.all(values)
    }

    /**
     * @param value A block that specifies the configuration information for invoking a Lambda function in AWS Lambda on the structured documents with their metadata and text extracted. You can use a Lambda function to apply advanced logic for creating, modifying, or deleting document metadata and content. For more information, see [Advanced data manipulation](https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#advanced-data-manipulation). Detailed below.
     */
    @JvmName("gdbjodehmbutbefi")
    public suspend fun postExtractionHookConfiguration(`value`: Output<DataSourceCustomDocumentEnrichmentConfigurationPostExtractionHookConfigurationArgs>) {
        this.postExtractionHookConfiguration = value
    }

    /**
     * @param value Configuration information for invoking a Lambda function in AWS Lambda on the original or raw documents before extracting their metadata and text. You can use a Lambda function to apply advanced logic for creating, modifying, or deleting document metadata and content. For more information, see [Advanced data manipulation](https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#advanced-data-manipulation). Detailed below.
     */
    @JvmName("biyoksoyjjhjaego")
    public suspend fun preExtractionHookConfiguration(`value`: Output<DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationArgs>) {
        this.preExtractionHookConfiguration = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of a role with permission to run `pre_extraction_hook_configuration` and `post_extraction_hook_configuration` for altering document metadata and content during the document ingestion process. For more information, see [IAM roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
     */
    @JvmName("vxhwdqtmpawtlmwo")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value Configuration information to alter document attributes or metadata fields and content when ingesting documents into Amazon Kendra. Minimum number of `0` items. Maximum number of `100` items. Detailed below.
     */
    @JvmName("fgnmjeqbbgyotuhc")
    public suspend fun inlineConfigurations(`value`: List<DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inlineConfigurations = mapped
    }

    /**
     * @param argument Configuration information to alter document attributes or metadata fields and content when ingesting documents into Amazon Kendra. Minimum number of `0` items. Maximum number of `100` items. Detailed below.
     */
    @JvmName("fionokmlaxemiawn")
    public suspend fun inlineConfigurations(argument: List<suspend DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.inlineConfigurations = mapped
    }

    /**
     * @param argument Configuration information to alter document attributes or metadata fields and content when ingesting documents into Amazon Kendra. Minimum number of `0` items. Maximum number of `100` items. Detailed below.
     */
    @JvmName("ejprancpgcyqkdap")
    public suspend fun inlineConfigurations(vararg argument: suspend DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.inlineConfigurations = mapped
    }

    /**
     * @param argument Configuration information to alter document attributes or metadata fields and content when ingesting documents into Amazon Kendra. Minimum number of `0` items. Maximum number of `100` items. Detailed below.
     */
    @JvmName("tgpfrjhurotpkpig")
    public suspend fun inlineConfigurations(argument: suspend DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.inlineConfigurations = mapped
    }

    /**
     * @param values Configuration information to alter document attributes or metadata fields and content when ingesting documents into Amazon Kendra. Minimum number of `0` items. Maximum number of `100` items. Detailed below.
     */
    @JvmName("rjmajgeahhfxltpw")
    public suspend fun inlineConfigurations(vararg values: DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inlineConfigurations = mapped
    }

    /**
     * @param value A block that specifies the configuration information for invoking a Lambda function in AWS Lambda on the structured documents with their metadata and text extracted. You can use a Lambda function to apply advanced logic for creating, modifying, or deleting document metadata and content. For more information, see [Advanced data manipulation](https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#advanced-data-manipulation). Detailed below.
     */
    @JvmName("ojywknluchbapkvy")
    public suspend fun postExtractionHookConfiguration(`value`: DataSourceCustomDocumentEnrichmentConfigurationPostExtractionHookConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.postExtractionHookConfiguration = mapped
    }

    /**
     * @param argument A block that specifies the configuration information for invoking a Lambda function in AWS Lambda on the structured documents with their metadata and text extracted. You can use a Lambda function to apply advanced logic for creating, modifying, or deleting document metadata and content. For more information, see [Advanced data manipulation](https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#advanced-data-manipulation). Detailed below.
     */
    @JvmName("dildowhqixufjjpt")
    public suspend fun postExtractionHookConfiguration(argument: suspend DataSourceCustomDocumentEnrichmentConfigurationPostExtractionHookConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            DataSourceCustomDocumentEnrichmentConfigurationPostExtractionHookConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.postExtractionHookConfiguration = mapped
    }

    /**
     * @param value Configuration information for invoking a Lambda function in AWS Lambda on the original or raw documents before extracting their metadata and text. You can use a Lambda function to apply advanced logic for creating, modifying, or deleting document metadata and content. For more information, see [Advanced data manipulation](https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#advanced-data-manipulation). Detailed below.
     */
    @JvmName("vnasldpkqevrdxrk")
    public suspend fun preExtractionHookConfiguration(`value`: DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preExtractionHookConfiguration = mapped
    }

    /**
     * @param argument Configuration information for invoking a Lambda function in AWS Lambda on the original or raw documents before extracting their metadata and text. You can use a Lambda function to apply advanced logic for creating, modifying, or deleting document metadata and content. For more information, see [Advanced data manipulation](https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#advanced-data-manipulation). Detailed below.
     */
    @JvmName("ljegdkhvxomdhyos")
    public suspend fun preExtractionHookConfiguration(argument: suspend DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.preExtractionHookConfiguration = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of a role with permission to run `pre_extraction_hook_configuration` and `post_extraction_hook_configuration` for altering document metadata and content during the document ingestion process. For more information, see [IAM roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
     */
    @JvmName("nhhtchotwifavlwl")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    internal fun build(): DataSourceCustomDocumentEnrichmentConfigurationArgs =
        DataSourceCustomDocumentEnrichmentConfigurationArgs(
            inlineConfigurations = inlineConfigurations,
            postExtractionHookConfiguration = postExtractionHookConfiguration,
            preExtractionHookConfiguration = preExtractionHookConfiguration,
            roleArn = roleArn,
        )
}
