@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.inputs

import com.pulumi.aws.kendra.inputs.DataSourceCustomDocumentEnrichmentConfigurationPostExtractionHookConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property invocationCondition A block that specifies the condition used for when a Lambda function should be invoked. For example, you can specify a condition that if there are empty date-time values, then Amazon Kendra should invoke a function that inserts the current date-time. See invocation_condition.
 * @property lambdaArn The Amazon Resource Name (ARN) of a Lambda Function that can manipulate your document metadata fields or attributes and content.
 * @property s3Bucket Stores the original, raw documents or the structured, parsed documents before and after altering them. For more information, see [Data contracts for Lambda functions](https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#cde-data-contracts-lambda).
 */
public data class
DataSourceCustomDocumentEnrichmentConfigurationPostExtractionHookConfigurationArgs(
    public val invocationCondition: Output<DataSourceCustomDocumentEnrichmentConfigurationPostExtractionHookConfigurationInvocationConditionArgs>? =
        null,
    public val lambdaArn: Output<String>,
    public val s3Bucket: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.kendra.inputs.DataSourceCustomDocumentEnrichmentConfigurationPostExtractionHookConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.kendra.inputs.DataSourceCustomDocumentEnrichmentConfigurationPostExtractionHookConfigurationArgs =
        com.pulumi.aws.kendra.inputs.DataSourceCustomDocumentEnrichmentConfigurationPostExtractionHookConfigurationArgs.builder()
            .invocationCondition(
                invocationCondition?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .lambdaArn(lambdaArn.applyValue({ args0 -> args0 }))
            .s3Bucket(s3Bucket.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSourceCustomDocumentEnrichmentConfigurationPostExtractionHookConfigurationArgs].
 */
@PulumiTagMarker
public class
DataSourceCustomDocumentEnrichmentConfigurationPostExtractionHookConfigurationArgsBuilder
internal constructor() {
    private var invocationCondition:
        Output<DataSourceCustomDocumentEnrichmentConfigurationPostExtractionHookConfigurationInvocationConditionArgs>? =
        null

    private var lambdaArn: Output<String>? = null

    private var s3Bucket: Output<String>? = null

    /**
     * @param value A block that specifies the condition used for when a Lambda function should be invoked. For example, you can specify a condition that if there are empty date-time values, then Amazon Kendra should invoke a function that inserts the current date-time. See invocation_condition.
     */
    @JvmName("jagdbjpefcuuscps")
    public suspend fun invocationCondition(`value`: Output<DataSourceCustomDocumentEnrichmentConfigurationPostExtractionHookConfigurationInvocationConditionArgs>) {
        this.invocationCondition = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of a Lambda Function that can manipulate your document metadata fields or attributes and content.
     */
    @JvmName("ixreyiehwvlwaiog")
    public suspend fun lambdaArn(`value`: Output<String>) {
        this.lambdaArn = value
    }

    /**
     * @param value Stores the original, raw documents or the structured, parsed documents before and after altering them. For more information, see [Data contracts for Lambda functions](https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#cde-data-contracts-lambda).
     */
    @JvmName("ihedtmbprgjugvpu")
    public suspend fun s3Bucket(`value`: Output<String>) {
        this.s3Bucket = value
    }

    /**
     * @param value A block that specifies the condition used for when a Lambda function should be invoked. For example, you can specify a condition that if there are empty date-time values, then Amazon Kendra should invoke a function that inserts the current date-time. See invocation_condition.
     */
    @JvmName("pwvubgcbinyffocb")
    public suspend fun invocationCondition(`value`: DataSourceCustomDocumentEnrichmentConfigurationPostExtractionHookConfigurationInvocationConditionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.invocationCondition = mapped
    }

    /**
     * @param argument A block that specifies the condition used for when a Lambda function should be invoked. For example, you can specify a condition that if there are empty date-time values, then Amazon Kendra should invoke a function that inserts the current date-time. See invocation_condition.
     */
    @JvmName("scukmwxognxuqwmc")
    public suspend fun invocationCondition(argument: suspend DataSourceCustomDocumentEnrichmentConfigurationPostExtractionHookConfigurationInvocationConditionArgsBuilder.() -> Unit) {
        val toBeMapped =
            DataSourceCustomDocumentEnrichmentConfigurationPostExtractionHookConfigurationInvocationConditionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.invocationCondition = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of a Lambda Function that can manipulate your document metadata fields or attributes and content.
     */
    @JvmName("cmbxyvupittwclwp")
    public suspend fun lambdaArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lambdaArn = mapped
    }

    /**
     * @param value Stores the original, raw documents or the structured, parsed documents before and after altering them. For more information, see [Data contracts for Lambda functions](https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#cde-data-contracts-lambda).
     */
    @JvmName("lpjytqdwtseeltfg")
    public suspend fun s3Bucket(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3Bucket = mapped
    }

    internal fun build(): DataSourceCustomDocumentEnrichmentConfigurationPostExtractionHookConfigurationArgs =
        DataSourceCustomDocumentEnrichmentConfigurationPostExtractionHookConfigurationArgs(
            invocationCondition = invocationCondition,
            lambdaArn = lambdaArn ?: throw PulumiNullFieldException("lambdaArn"),
            s3Bucket = s3Bucket ?: throw PulumiNullFieldException("s3Bucket"),
        )
}
