@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.inputs

import com.pulumi.aws.kendra.inputs.DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationInvocationConditionConditionOnValueArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property dateValue A date expressed as an ISO 8601 string. It is important for the time zone to be included in the ISO 8601 date-time format. As of this writing only UTC is supported. For example, `2012-03-25T12:30:10+00:00`.
 * @property longValue A long integer value.
 * @property stringListValues A list of strings.
 * @property stringValue
 */
public data class
DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationInvocationConditionConditionOnValueArgs(
    public val dateValue: Output<String>? = null,
    public val longValue: Output<Int>? = null,
    public val stringListValues: Output<List<String>>? = null,
    public val stringValue: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.kendra.inputs.DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationInvocationConditionConditionOnValueArgs> {
    override fun toJava(): com.pulumi.aws.kendra.inputs.DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationInvocationConditionConditionOnValueArgs =
        com.pulumi.aws.kendra.inputs.DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationInvocationConditionConditionOnValueArgs.builder()
            .dateValue(dateValue?.applyValue({ args0 -> args0 }))
            .longValue(longValue?.applyValue({ args0 -> args0 }))
            .stringListValues(stringListValues?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .stringValue(stringValue?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationInvocationConditionConditionOnValueArgs].
 */
@PulumiTagMarker
public class
DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationInvocationConditionConditionOnValueArgsBuilder
internal constructor() {
    private var dateValue: Output<String>? = null

    private var longValue: Output<Int>? = null

    private var stringListValues: Output<List<String>>? = null

    private var stringValue: Output<String>? = null

    /**
     * @param value A date expressed as an ISO 8601 string. It is important for the time zone to be included in the ISO 8601 date-time format. As of this writing only UTC is supported. For example, `2012-03-25T12:30:10+00:00`.
     */
    @JvmName("uywarvodtrjyxpnt")
    public suspend fun dateValue(`value`: Output<String>) {
        this.dateValue = value
    }

    /**
     * @param value A long integer value.
     */
    @JvmName("ngpoqwsiusikmnoc")
    public suspend fun longValue(`value`: Output<Int>) {
        this.longValue = value
    }

    /**
     * @param value A list of strings.
     */
    @JvmName("rbdwriurtfedmlej")
    public suspend fun stringListValues(`value`: Output<List<String>>) {
        this.stringListValues = value
    }

    @JvmName("iwruvbywjgyihser")
    public suspend fun stringListValues(vararg values: Output<String>) {
        this.stringListValues = Output.all(values.asList())
    }

    /**
     * @param values A list of strings.
     */
    @JvmName("rsnsgkywrambcahu")
    public suspend fun stringListValues(values: List<Output<String>>) {
        this.stringListValues = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("baqnflnsbjdbbbay")
    public suspend fun stringValue(`value`: Output<String>) {
        this.stringValue = value
    }

    /**
     * @param value A date expressed as an ISO 8601 string. It is important for the time zone to be included in the ISO 8601 date-time format. As of this writing only UTC is supported. For example, `2012-03-25T12:30:10+00:00`.
     */
    @JvmName("bipnjvlugadivtjf")
    public suspend fun dateValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dateValue = mapped
    }

    /**
     * @param value A long integer value.
     */
    @JvmName("cwsbkmjuhpkjgnen")
    public suspend fun longValue(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.longValue = mapped
    }

    /**
     * @param value A list of strings.
     */
    @JvmName("uljxeydekhmxxlyp")
    public suspend fun stringListValues(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stringListValues = mapped
    }

    /**
     * @param values A list of strings.
     */
    @JvmName("ljhowpadbquucfoa")
    public suspend fun stringListValues(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stringListValues = mapped
    }

    /**
     * @param value
     */
    @JvmName("tirqmxgktbrapivj")
    public suspend fun stringValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stringValue = mapped
    }

    internal fun build(): DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationInvocationConditionConditionOnValueArgs =
        DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationInvocationConditionConditionOnValueArgs(
            dateValue = dateValue,
            longValue = longValue,
            stringListValues = stringListValues,
            stringValue = stringValue,
        )
}
