@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.inputs

import com.pulumi.aws.kendra.inputs.ExperienceConfigurationContentSourceConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property dataSourceIds The identifiers of the data sources you want to use for your Amazon Kendra experience. Maximum number of 100 items.
 * @property directPutContent Whether to use documents you indexed directly using the `BatchPutDocument API`. Defaults to `false`.
 * @property faqIds The identifier of the FAQs that you want to use for your Amazon Kendra experience. Maximum number of 100 items.
 */
public data class ExperienceConfigurationContentSourceConfigurationArgs(
    public val dataSourceIds: Output<List<String>>? = null,
    public val directPutContent: Output<Boolean>? = null,
    public val faqIds: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.kendra.inputs.ExperienceConfigurationContentSourceConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.kendra.inputs.ExperienceConfigurationContentSourceConfigurationArgs =
        com.pulumi.aws.kendra.inputs.ExperienceConfigurationContentSourceConfigurationArgs.builder()
            .dataSourceIds(dataSourceIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .directPutContent(directPutContent?.applyValue({ args0 -> args0 }))
            .faqIds(faqIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ExperienceConfigurationContentSourceConfigurationArgs].
 */
@PulumiTagMarker
public class ExperienceConfigurationContentSourceConfigurationArgsBuilder internal constructor() {
    private var dataSourceIds: Output<List<String>>? = null

    private var directPutContent: Output<Boolean>? = null

    private var faqIds: Output<List<String>>? = null

    /**
     * @param value The identifiers of the data sources you want to use for your Amazon Kendra experience. Maximum number of 100 items.
     */
    @JvmName("xidamlgsdomicnhl")
    public suspend fun dataSourceIds(`value`: Output<List<String>>) {
        this.dataSourceIds = value
    }

    @JvmName("lisykavwfufioios")
    public suspend fun dataSourceIds(vararg values: Output<String>) {
        this.dataSourceIds = Output.all(values.asList())
    }

    /**
     * @param values The identifiers of the data sources you want to use for your Amazon Kendra experience. Maximum number of 100 items.
     */
    @JvmName("vpkdnyunahdxkcjj")
    public suspend fun dataSourceIds(values: List<Output<String>>) {
        this.dataSourceIds = Output.all(values)
    }

    /**
     * @param value Whether to use documents you indexed directly using the `BatchPutDocument API`. Defaults to `false`.
     */
    @JvmName("qaiaqstorxclafbm")
    public suspend fun directPutContent(`value`: Output<Boolean>) {
        this.directPutContent = value
    }

    /**
     * @param value The identifier of the FAQs that you want to use for your Amazon Kendra experience. Maximum number of 100 items.
     */
    @JvmName("pqkqcienvgsxhakp")
    public suspend fun faqIds(`value`: Output<List<String>>) {
        this.faqIds = value
    }

    @JvmName("mubvpelewjbaybbm")
    public suspend fun faqIds(vararg values: Output<String>) {
        this.faqIds = Output.all(values.asList())
    }

    /**
     * @param values The identifier of the FAQs that you want to use for your Amazon Kendra experience. Maximum number of 100 items.
     */
    @JvmName("eoywrjppialhgxfk")
    public suspend fun faqIds(values: List<Output<String>>) {
        this.faqIds = Output.all(values)
    }

    /**
     * @param value The identifiers of the data sources you want to use for your Amazon Kendra experience. Maximum number of 100 items.
     */
    @JvmName("ldhgumbrnmxrkamy")
    public suspend fun dataSourceIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSourceIds = mapped
    }

    /**
     * @param values The identifiers of the data sources you want to use for your Amazon Kendra experience. Maximum number of 100 items.
     */
    @JvmName("qeicjyykvredknqu")
    public suspend fun dataSourceIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataSourceIds = mapped
    }

    /**
     * @param value Whether to use documents you indexed directly using the `BatchPutDocument API`. Defaults to `false`.
     */
    @JvmName("emupvipuqoebnvfj")
    public suspend fun directPutContent(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.directPutContent = mapped
    }

    /**
     * @param value The identifier of the FAQs that you want to use for your Amazon Kendra experience. Maximum number of 100 items.
     */
    @JvmName("nlyuwtjdpmuaitdh")
    public suspend fun faqIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.faqIds = mapped
    }

    /**
     * @param values The identifier of the FAQs that you want to use for your Amazon Kendra experience. Maximum number of 100 items.
     */
    @JvmName("jabkinncudlovvvg")
    public suspend fun faqIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.faqIds = mapped
    }

    internal fun build(): ExperienceConfigurationContentSourceConfigurationArgs =
        ExperienceConfigurationContentSourceConfigurationArgs(
            dataSourceIds = dataSourceIds,
            directPutContent = directPutContent,
            faqIds = faqIds,
        )
}
