@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.inputs

import com.pulumi.aws.kendra.inputs.ExperienceConfigurationUserIdentityConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property identityAttributeName The AWS SSO field name that contains the identifiers of your users, such as their emails.
 */
public data class ExperienceConfigurationUserIdentityConfigurationArgs(
    public val identityAttributeName: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.kendra.inputs.ExperienceConfigurationUserIdentityConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.kendra.inputs.ExperienceConfigurationUserIdentityConfigurationArgs =
        com.pulumi.aws.kendra.inputs.ExperienceConfigurationUserIdentityConfigurationArgs.builder()
            .identityAttributeName(identityAttributeName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExperienceConfigurationUserIdentityConfigurationArgs].
 */
@PulumiTagMarker
public class ExperienceConfigurationUserIdentityConfigurationArgsBuilder internal constructor() {
    private var identityAttributeName: Output<String>? = null

    /**
     * @param value The AWS SSO field name that contains the identifiers of your users, such as their emails.
     */
    @JvmName("swexwruariycefxc")
    public suspend fun identityAttributeName(`value`: Output<String>) {
        this.identityAttributeName = value
    }

    /**
     * @param value The AWS SSO field name that contains the identifiers of your users, such as their emails.
     */
    @JvmName("otwqvpkwhjcbemug")
    public suspend fun identityAttributeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.identityAttributeName = mapped
    }

    internal fun build(): ExperienceConfigurationUserIdentityConfigurationArgs =
        ExperienceConfigurationUserIdentityConfigurationArgs(
            identityAttributeName = identityAttributeName ?: throw
                PulumiNullFieldException("identityAttributeName"),
        )
}
