@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.inputs

import com.pulumi.aws.kendra.inputs.GetIndexPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getIndex.
 * @property id Returns information on a specific Index by id.
 * @property tags Metadata that helps organize the Indices you create.
 */
public data class GetIndexPlainArgs(
    public val id: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.kendra.inputs.GetIndexPlainArgs> {
    override fun toJava(): com.pulumi.aws.kendra.inputs.GetIndexPlainArgs =
        com.pulumi.aws.kendra.inputs.GetIndexPlainArgs.builder()
            .id(id.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetIndexPlainArgs].
 */
@PulumiTagMarker
public class GetIndexPlainArgsBuilder internal constructor() {
    private var id: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Returns information on a specific Index by id.
     */
    @JvmName("njffwpqbadiahbev")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value Metadata that helps organize the Indices you create.
     */
    @JvmName("rbeqdnpfilffyafq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Metadata that helps organize the Indices you create.
     */
    @JvmName("qopnqocxaclcoiro")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetIndexPlainArgs = GetIndexPlainArgs(
        id = id ?: throw PulumiNullFieldException("id"),
        tags = tags,
    )
}
