@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.inputs

import com.pulumi.aws.kendra.inputs.GetQuerySuggestionsBlockListPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getQuerySuggestionsBlockList.
 * @property indexId Identifier of the index that contains the block list.
 * @property querySuggestionsBlockListId Identifier of the block list.
 * @property tags Metadata that helps organize the block list you create.
 */
public data class GetQuerySuggestionsBlockListPlainArgs(
    public val indexId: String,
    public val querySuggestionsBlockListId: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.kendra.inputs.GetQuerySuggestionsBlockListPlainArgs> {
    override fun toJava(): com.pulumi.aws.kendra.inputs.GetQuerySuggestionsBlockListPlainArgs =
        com.pulumi.aws.kendra.inputs.GetQuerySuggestionsBlockListPlainArgs.builder()
            .indexId(indexId.let({ args0 -> args0 }))
            .querySuggestionsBlockListId(querySuggestionsBlockListId.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetQuerySuggestionsBlockListPlainArgs].
 */
@PulumiTagMarker
public class GetQuerySuggestionsBlockListPlainArgsBuilder internal constructor() {
    private var indexId: String? = null

    private var querySuggestionsBlockListId: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Identifier of the index that contains the block list.
     */
    @JvmName("pqewxasymosjqiuv")
    public suspend fun indexId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.indexId = mapped
    }

    /**
     * @param value Identifier of the block list.
     */
    @JvmName("jruvfsddhhkihcxw")
    public suspend fun querySuggestionsBlockListId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.querySuggestionsBlockListId = mapped
    }

    /**
     * @param value Metadata that helps organize the block list you create.
     */
    @JvmName("bebgecfxhifkactk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Metadata that helps organize the block list you create.
     */
    @JvmName("rujcrcykxnuiqsqm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetQuerySuggestionsBlockListPlainArgs =
        GetQuerySuggestionsBlockListPlainArgs(
            indexId = indexId ?: throw PulumiNullFieldException("indexId"),
            querySuggestionsBlockListId = querySuggestionsBlockListId ?: throw
                PulumiNullFieldException("querySuggestionsBlockListId"),
            tags = tags,
        )
}
