@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.inputs

import com.pulumi.aws.kendra.inputs.GetThesaurusPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getThesaurus.
 * @property indexId Identifier of the index that contains the Thesaurus.
 * @property tags Metadata that helps organize the Thesaurus you create.
 * @property thesaurusId Identifier of the Thesaurus.
 */
public data class GetThesaurusPlainArgs(
    public val indexId: String,
    public val tags: Map<String, String>? = null,
    public val thesaurusId: String,
) : ConvertibleToJava<com.pulumi.aws.kendra.inputs.GetThesaurusPlainArgs> {
    override fun toJava(): com.pulumi.aws.kendra.inputs.GetThesaurusPlainArgs =
        com.pulumi.aws.kendra.inputs.GetThesaurusPlainArgs.builder()
            .indexId(indexId.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .thesaurusId(thesaurusId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetThesaurusPlainArgs].
 */
@PulumiTagMarker
public class GetThesaurusPlainArgsBuilder internal constructor() {
    private var indexId: String? = null

    private var tags: Map<String, String>? = null

    private var thesaurusId: String? = null

    /**
     * @param value Identifier of the index that contains the Thesaurus.
     */
    @JvmName("moisthcgyjpepfso")
    public suspend fun indexId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.indexId = mapped
    }

    /**
     * @param value Metadata that helps organize the Thesaurus you create.
     */
    @JvmName("iypftmlmxynkdhmd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Metadata that helps organize the Thesaurus you create.
     */
    @JvmName("pswgxgfucritqbsl")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value Identifier of the Thesaurus.
     */
    @JvmName("klhihxtjlksuknij")
    public suspend fun thesaurusId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.thesaurusId = mapped
    }

    internal fun build(): GetThesaurusPlainArgs = GetThesaurusPlainArgs(
        indexId = indexId ?: throw PulumiNullFieldException("indexId"),
        tags = tags,
        thesaurusId = thesaurusId ?: throw PulumiNullFieldException("thesaurusId"),
    )
}
