@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.inputs

import com.pulumi.aws.kendra.inputs.IndexCapacityUnitsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property queryCapacityUnits The amount of extra query capacity for an index and GetQuerySuggestions capacity. For more information, refer to [QueryCapacityUnits](https://docs.aws.amazon.com/kendra/latest/dg/API_CapacityUnitsConfiguration.html#Kendra-Type-CapacityUnitsConfiguration-QueryCapacityUnits).
 * @property storageCapacityUnits The amount of extra storage capacity for an index. A single capacity unit provides 30 GB of storage space or 100,000 documents, whichever is reached first. Minimum value of 0.
 */
public data class IndexCapacityUnitsArgs(
    public val queryCapacityUnits: Output<Int>? = null,
    public val storageCapacityUnits: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.kendra.inputs.IndexCapacityUnitsArgs> {
    override fun toJava(): com.pulumi.aws.kendra.inputs.IndexCapacityUnitsArgs =
        com.pulumi.aws.kendra.inputs.IndexCapacityUnitsArgs.builder()
            .queryCapacityUnits(queryCapacityUnits?.applyValue({ args0 -> args0 }))
            .storageCapacityUnits(storageCapacityUnits?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IndexCapacityUnitsArgs].
 */
@PulumiTagMarker
public class IndexCapacityUnitsArgsBuilder internal constructor() {
    private var queryCapacityUnits: Output<Int>? = null

    private var storageCapacityUnits: Output<Int>? = null

    /**
     * @param value The amount of extra query capacity for an index and GetQuerySuggestions capacity. For more information, refer to [QueryCapacityUnits](https://docs.aws.amazon.com/kendra/latest/dg/API_CapacityUnitsConfiguration.html#Kendra-Type-CapacityUnitsConfiguration-QueryCapacityUnits).
     */
    @JvmName("qigpmiwiaoajqjrl")
    public suspend fun queryCapacityUnits(`value`: Output<Int>) {
        this.queryCapacityUnits = value
    }

    /**
     * @param value The amount of extra storage capacity for an index. A single capacity unit provides 30 GB of storage space or 100,000 documents, whichever is reached first. Minimum value of 0.
     */
    @JvmName("dhywskdgydloolvo")
    public suspend fun storageCapacityUnits(`value`: Output<Int>) {
        this.storageCapacityUnits = value
    }

    /**
     * @param value The amount of extra query capacity for an index and GetQuerySuggestions capacity. For more information, refer to [QueryCapacityUnits](https://docs.aws.amazon.com/kendra/latest/dg/API_CapacityUnitsConfiguration.html#Kendra-Type-CapacityUnitsConfiguration-QueryCapacityUnits).
     */
    @JvmName("wiagaoxuypcpwgmw")
    public suspend fun queryCapacityUnits(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryCapacityUnits = mapped
    }

    /**
     * @param value The amount of extra storage capacity for an index. A single capacity unit provides 30 GB of storage space or 100,000 documents, whichever is reached first. Minimum value of 0.
     */
    @JvmName("wyyruwtmwkthfhbn")
    public suspend fun storageCapacityUnits(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageCapacityUnits = mapped
    }

    internal fun build(): IndexCapacityUnitsArgs = IndexCapacityUnitsArgs(
        queryCapacityUnits = queryCapacityUnits,
        storageCapacityUnits = storageCapacityUnits,
    )
}
