@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.inputs

import com.pulumi.aws.kendra.inputs.IndexUserTokenConfigurationsJwtTokenTypeConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property claimRegex The regular expression that identifies the claim. Minimum length of 1. Maximum length of 100.
 * @property groupAttributeField The group attribute field. Minimum length of 1. Maximum length of 100.
 * @property issuer The issuer of the token. Minimum length of 1. Maximum length of 65.
 * @property keyLocation The location of the key. Valid values are `URL` or `SECRET_MANAGER`
 * @property secretsManagerArn The Amazon Resource Name (ARN) of the secret.
 * @property url The signing key URL. Valid pattern is `^(https?|ftp|file):\/\/([^\s]*)`
 * @property userNameAttributeField The user name attribute field. Minimum length of 1. Maximum length of 100.
 */
public data class IndexUserTokenConfigurationsJwtTokenTypeConfigurationArgs(
    public val claimRegex: Output<String>? = null,
    public val groupAttributeField: Output<String>? = null,
    public val issuer: Output<String>? = null,
    public val keyLocation: Output<String>,
    public val secretsManagerArn: Output<String>? = null,
    public val url: Output<String>? = null,
    public val userNameAttributeField: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.kendra.inputs.IndexUserTokenConfigurationsJwtTokenTypeConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.kendra.inputs.IndexUserTokenConfigurationsJwtTokenTypeConfigurationArgs =
        com.pulumi.aws.kendra.inputs.IndexUserTokenConfigurationsJwtTokenTypeConfigurationArgs.builder()
            .claimRegex(claimRegex?.applyValue({ args0 -> args0 }))
            .groupAttributeField(groupAttributeField?.applyValue({ args0 -> args0 }))
            .issuer(issuer?.applyValue({ args0 -> args0 }))
            .keyLocation(keyLocation.applyValue({ args0 -> args0 }))
            .secretsManagerArn(secretsManagerArn?.applyValue({ args0 -> args0 }))
            .url(url?.applyValue({ args0 -> args0 }))
            .userNameAttributeField(userNameAttributeField?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IndexUserTokenConfigurationsJwtTokenTypeConfigurationArgs].
 */
@PulumiTagMarker
public class IndexUserTokenConfigurationsJwtTokenTypeConfigurationArgsBuilder internal constructor() {
    private var claimRegex: Output<String>? = null

    private var groupAttributeField: Output<String>? = null

    private var issuer: Output<String>? = null

    private var keyLocation: Output<String>? = null

    private var secretsManagerArn: Output<String>? = null

    private var url: Output<String>? = null

    private var userNameAttributeField: Output<String>? = null

    /**
     * @param value The regular expression that identifies the claim. Minimum length of 1. Maximum length of 100.
     */
    @JvmName("pxosconfxxuckbwm")
    public suspend fun claimRegex(`value`: Output<String>) {
        this.claimRegex = value
    }

    /**
     * @param value The group attribute field. Minimum length of 1. Maximum length of 100.
     */
    @JvmName("jxvepvrnmmmydcqi")
    public suspend fun groupAttributeField(`value`: Output<String>) {
        this.groupAttributeField = value
    }

    /**
     * @param value The issuer of the token. Minimum length of 1. Maximum length of 65.
     */
    @JvmName("ufyhmjorspeijskp")
    public suspend fun issuer(`value`: Output<String>) {
        this.issuer = value
    }

    /**
     * @param value The location of the key. Valid values are `URL` or `SECRET_MANAGER`
     */
    @JvmName("jgwqjyfvftgferuq")
    public suspend fun keyLocation(`value`: Output<String>) {
        this.keyLocation = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the secret.
     */
    @JvmName("ycjtxfrmbpcijfdk")
    public suspend fun secretsManagerArn(`value`: Output<String>) {
        this.secretsManagerArn = value
    }

    /**
     * @param value The signing key URL. Valid pattern is `^(https?|ftp|file):\/\/([^\s]*)`
     */
    @JvmName("dfanflhldukkptcf")
    public suspend fun url(`value`: Output<String>) {
        this.url = value
    }

    /**
     * @param value The user name attribute field. Minimum length of 1. Maximum length of 100.
     */
    @JvmName("nepirvyqoqaffmfn")
    public suspend fun userNameAttributeField(`value`: Output<String>) {
        this.userNameAttributeField = value
    }

    /**
     * @param value The regular expression that identifies the claim. Minimum length of 1. Maximum length of 100.
     */
    @JvmName("yyincwamialrjomn")
    public suspend fun claimRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.claimRegex = mapped
    }

    /**
     * @param value The group attribute field. Minimum length of 1. Maximum length of 100.
     */
    @JvmName("orqfwxuxjboiqpmc")
    public suspend fun groupAttributeField(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupAttributeField = mapped
    }

    /**
     * @param value The issuer of the token. Minimum length of 1. Maximum length of 65.
     */
    @JvmName("lygodacabifvuoag")
    public suspend fun issuer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.issuer = mapped
    }

    /**
     * @param value The location of the key. Valid values are `URL` or `SECRET_MANAGER`
     */
    @JvmName("bqagtmcalhrdponp")
    public suspend fun keyLocation(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyLocation = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the secret.
     */
    @JvmName("xpktwyrgpecoanjm")
    public suspend fun secretsManagerArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretsManagerArn = mapped
    }

    /**
     * @param value The signing key URL. Valid pattern is `^(https?|ftp|file):\/\/([^\s]*)`
     */
    @JvmName("knkrhxagpvfbdknx")
    public suspend fun url(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.url = mapped
    }

    /**
     * @param value The user name attribute field. Minimum length of 1. Maximum length of 100.
     */
    @JvmName("nsxfunmlroetkghd")
    public suspend fun userNameAttributeField(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userNameAttributeField = mapped
    }

    internal fun build(): IndexUserTokenConfigurationsJwtTokenTypeConfigurationArgs =
        IndexUserTokenConfigurationsJwtTokenTypeConfigurationArgs(
            claimRegex = claimRegex,
            groupAttributeField = groupAttributeField,
            issuer = issuer,
            keyLocation = keyLocation ?: throw PulumiNullFieldException("keyLocation"),
            secretsManagerArn = secretsManagerArn,
            url = url,
            userNameAttributeField = userNameAttributeField,
        )
}
