@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property accessControlListConfiguration A block that provides the path to the S3 bucket that contains the user context filtering files for the data source. For the format of the file, see [Access control for S3 data sources](https://docs.aws.amazon.com/kendra/latest/dg/s3-acl.html). Detailed below.
 * @property bucketName The name of the bucket that contains the documents.
 * @property documentsMetadataConfiguration A block that defines the Document metadata files that contain information such as the document access control information, source URI, document author, and custom attributes. Each metadata file contains metadata about a single document. Detailed below.
 * @property exclusionPatterns A list of glob patterns for documents that should not be indexed. If a document that matches an inclusion prefix or inclusion pattern also matches an exclusion pattern, the document is not indexed. Refer to [Exclusion Patterns for more examples](https://docs.aws.amazon.com/kendra/latest/dg/API_S3DataSourceConfiguration.html#Kendra-Type-S3DataSourceConfiguration-ExclusionPatterns).
 * @property inclusionPatterns A list of glob patterns for documents that should be indexed. If a document that matches an inclusion pattern also matches an exclusion pattern, the document is not indexed. Refer to [Inclusion Patterns for more examples](https://docs.aws.amazon.com/kendra/latest/dg/API_S3DataSourceConfiguration.html#Kendra-Type-S3DataSourceConfiguration-InclusionPatterns).
 * @property inclusionPrefixes A list of S3 prefixes for the documents that should be included in the index.
 */
public data class DataSourceConfigurationS3Configuration(
    public val accessControlListConfiguration: DataSourceConfigurationS3ConfigurationAccessControlListConfiguration? = null,
    public val bucketName: String,
    public val documentsMetadataConfiguration: DataSourceConfigurationS3ConfigurationDocumentsMetadataConfiguration? = null,
    public val exclusionPatterns: List<String>? = null,
    public val inclusionPatterns: List<String>? = null,
    public val inclusionPrefixes: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kendra.outputs.DataSourceConfigurationS3Configuration): DataSourceConfigurationS3Configuration = DataSourceConfigurationS3Configuration(
            accessControlListConfiguration = javaType.accessControlListConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kendra.kotlin.outputs.DataSourceConfigurationS3ConfigurationAccessControlListConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            bucketName = javaType.bucketName(),
            documentsMetadataConfiguration = javaType.documentsMetadataConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kendra.kotlin.outputs.DataSourceConfigurationS3ConfigurationDocumentsMetadataConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            exclusionPatterns = javaType.exclusionPatterns().map({ args0 -> args0 }),
            inclusionPatterns = javaType.inclusionPatterns().map({ args0 -> args0 }),
            inclusionPrefixes = javaType.inclusionPrefixes().map({ args0 -> args0 }),
        )
    }
}
