@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property credentials Your secret ARN, which you can create in AWS Secrets Manager. The credentials are optional. You use a secret if web proxy credentials are required to connect to a website host. Amazon Kendra currently support basic authentication to connect to a web proxy server. The secret stores your credentials.
 * @property host The name of the website host you want to connect to via a web proxy server. For example, the host name of `https://a.example.com/page1.html` is `"a.example.com"`.
 * @property port The port number of the website host you want to connect to via a web proxy server. For example, the port for `https://a.example.com/page1.html` is `443`, the standard port for HTTPS.
 */
public data class DataSourceConfigurationWebCrawlerConfigurationProxyConfiguration(
    public val credentials: String? = null,
    public val host: String,
    public val port: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kendra.outputs.DataSourceConfigurationWebCrawlerConfigurationProxyConfiguration): DataSourceConfigurationWebCrawlerConfigurationProxyConfiguration =
            DataSourceConfigurationWebCrawlerConfigurationProxyConfiguration(
                credentials = javaType.credentials().map({ args0 -> args0 }).orElse(null),
                host = javaType.host(),
                port = javaType.port(),
            )
    }
}
