@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property seedUrlConfiguration A block that specifies the configuration of the seed or starting point URLs of the websites you want to crawl. You can choose to crawl only the website host names, or the website host names with subdomains, or the website host names with subdomains and other domains that the webpages link to. You can list up to `100` seed URLs. Detailed below.
 * @property siteMapsConfiguration A block that specifies the configuration of the sitemap URLs of the websites you want to crawl. Only URLs belonging to the same website host names are crawled. You can list up to `3` sitemap URLs. Detailed below.
 */
public data class DataSourceConfigurationWebCrawlerConfigurationUrls(
    public val seedUrlConfiguration: DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfiguration? = null,
    public val siteMapsConfiguration: DataSourceConfigurationWebCrawlerConfigurationUrlsSiteMapsConfiguration? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kendra.outputs.DataSourceConfigurationWebCrawlerConfigurationUrls): DataSourceConfigurationWebCrawlerConfigurationUrls =
            DataSourceConfigurationWebCrawlerConfigurationUrls(
                seedUrlConfiguration = javaType.seedUrlConfiguration().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.kendra.kotlin.outputs.DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfiguration.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                siteMapsConfiguration = javaType.siteMapsConfiguration().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.kendra.kotlin.outputs.DataSourceConfigurationWebCrawlerConfigurationUrlsSiteMapsConfiguration.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
