@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property inlineConfigurations Configuration information to alter document attributes or metadata fields and content when ingesting documents into Amazon Kendra. Minimum number of `0` items. Maximum number of `100` items. Detailed below.
 * @property postExtractionHookConfiguration A block that specifies the configuration information for invoking a Lambda function in AWS Lambda on the structured documents with their metadata and text extracted. You can use a Lambda function to apply advanced logic for creating, modifying, or deleting document metadata and content. For more information, see [Advanced data manipulation](https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#advanced-data-manipulation). Detailed below.
 * @property preExtractionHookConfiguration Configuration information for invoking a Lambda function in AWS Lambda on the original or raw documents before extracting their metadata and text. You can use a Lambda function to apply advanced logic for creating, modifying, or deleting document metadata and content. For more information, see [Advanced data manipulation](https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#advanced-data-manipulation). Detailed below.
 * @property roleArn The Amazon Resource Name (ARN) of a role with permission to run `pre_extraction_hook_configuration` and `post_extraction_hook_configuration` for altering document metadata and content during the document ingestion process. For more information, see [IAM roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
 */
public data class DataSourceCustomDocumentEnrichmentConfiguration(
    public val inlineConfigurations: List<DataSourceCustomDocumentEnrichmentConfigurationInlineConfiguration>? = null,
    public val postExtractionHookConfiguration: DataSourceCustomDocumentEnrichmentConfigurationPostExtractionHookConfiguration? = null,
    public val preExtractionHookConfiguration: DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfiguration? = null,
    public val roleArn: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kendra.outputs.DataSourceCustomDocumentEnrichmentConfiguration): DataSourceCustomDocumentEnrichmentConfiguration =
            DataSourceCustomDocumentEnrichmentConfiguration(
                inlineConfigurations = javaType.inlineConfigurations().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.kendra.kotlin.outputs.DataSourceCustomDocumentEnrichmentConfigurationInlineConfiguration.Companion.toKotlin(args0)
                    })
                }),
                postExtractionHookConfiguration = javaType.postExtractionHookConfiguration().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.kendra.kotlin.outputs.DataSourceCustomDocumentEnrichmentConfigurationPostExtractionHookConfiguration.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                preExtractionHookConfiguration = javaType.preExtractionHookConfiguration().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.kendra.kotlin.outputs.DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfiguration.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                roleArn = javaType.roleArn().map({ args0 -> args0 }).orElse(null),
            )
    }
}
