@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property targetDocumentAttributeKey The identifier of the target document attribute or metadata field. For example, 'Department' could be an identifier for the target attribute or metadata field that includes the department names associated with the documents.
 * @property targetDocumentAttributeValue The target value you want to create for the target attribute. For example, 'Finance' could be the target value for the target attribute key 'Department'. See target_document_attribute_value.
 * @property targetDocumentAttributeValueDeletion `TRUE` to delete the existing target value for your specified target attribute key. You cannot create a target value and set this to `TRUE`. To create a target value (`TargetDocumentAttributeValue`), set this to `FALSE`.
 */
public data class DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationTarget(
    public val targetDocumentAttributeKey: String? = null,
    public val targetDocumentAttributeValue: DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationTargetTargetDocumentAttributeValue? =
        null,
    public val targetDocumentAttributeValueDeletion: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kendra.outputs.DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationTarget): DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationTarget =
            DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationTarget(
                targetDocumentAttributeKey = javaType.targetDocumentAttributeKey().map({ args0 ->
                    args0
                }).orElse(null),
                targetDocumentAttributeValue = javaType.targetDocumentAttributeValue().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.kendra.kotlin.outputs.DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationTargetTargetDocumentAttributeValue.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                targetDocumentAttributeValueDeletion = javaType.targetDocumentAttributeValueDeletion().map({ args0 ->
                    args0
                }).orElse(null),
            )
    }
}
