@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property conditionDocumentAttributeKey The identifier of the document attribute used for the condition. For example, `_source_uri` could be an identifier for the attribute or metadata field that contains source URIs associated with the documents. Amazon Kendra currently does not support `_document_body` as an attribute key used for the condition.
 * @property conditionOnValue The value used by the operator. For example, you can specify the value 'financial' for strings in the `_source_uri` field that partially match or contain this value. See condition_on_value.
 * @property operator The condition operator. For example, you can use `Contains` to partially match a string. Valid Values: `GreaterThan` | `GreaterThanOrEquals` | `LessThan` | `LessThanOrEquals` | `Equals` | `NotEquals` | `Contains` | `NotContains` | `Exists` | `NotExists` | `BeginsWith`.
 */
public data class
DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationInvocationCondition(
    public val conditionDocumentAttributeKey: String,
    public val conditionOnValue: DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationInvocationConditionConditionOnValue? =
        null,
    public val `operator`: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kendra.outputs.DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationInvocationCondition): DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationInvocationCondition =
            DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationInvocationCondition(
                conditionDocumentAttributeKey = javaType.conditionDocumentAttributeKey(),
                conditionOnValue = javaType.conditionOnValue().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.kendra.kotlin.outputs.DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationInvocationConditionConditionOnValue.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                `operator` = javaType.`operator`(),
            )
    }
}
