@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property contentSourceConfiguration The identifiers of your data sources and FAQs. Or, you can specify that you want to use documents indexed via the `BatchPutDocument API`. The provider will only perform drift detection of its value when present in a configuration. Detailed below.
 * @property userIdentityConfiguration The AWS SSO field name that contains the identifiers of your users, such as their emails. Detailed below.
 */
public data class ExperienceConfiguration(
    public val contentSourceConfiguration: ExperienceConfigurationContentSourceConfiguration? = null,
    public val userIdentityConfiguration: ExperienceConfigurationUserIdentityConfiguration? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kendra.outputs.ExperienceConfiguration): ExperienceConfiguration = ExperienceConfiguration(
            contentSourceConfiguration = javaType.contentSourceConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kendra.kotlin.outputs.ExperienceConfigurationContentSourceConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            userIdentityConfiguration = javaType.userIdentityConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kendra.kotlin.outputs.ExperienceConfigurationUserIdentityConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
