@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property name Name of the index field. Minimum length of 1. Maximum length of 30.
 * @property relevances Block that provides manual tuning parameters to determine how the field affects the search results. Documented below.
 * @property searches Block that provides information about how the field is used during a search. Documented below.
 * @property type Data type of the index field. Valid values are `STRING_VALUE`, `STRING_LIST_VALUE`, `LONG_VALUE`, `DATE_VALUE`.
 */
public data class GetIndexDocumentMetadataConfigurationUpdate(
    public val name: String,
    public val relevances: List<GetIndexDocumentMetadataConfigurationUpdateRelevance>,
    public val searches: List<GetIndexDocumentMetadataConfigurationUpdateSearch>,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kendra.outputs.GetIndexDocumentMetadataConfigurationUpdate): GetIndexDocumentMetadataConfigurationUpdate = GetIndexDocumentMetadataConfigurationUpdate(
            name = javaType.name(),
            relevances = javaType.relevances().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kendra.kotlin.outputs.GetIndexDocumentMetadataConfigurationUpdateRelevance.Companion.toKotlin(args0)
                })
            }),
            searches = javaType.searches().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kendra.kotlin.outputs.GetIndexDocumentMetadataConfigurationUpdateSearch.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
        )
    }
}
