@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property jsonTokenTypeConfigurations A block that specifies the information about the JSON token type configuration.
 * @property jwtTokenTypeConfigurations A block that specifies the information about the JWT token type configuration.
 */
public data class GetIndexUserTokenConfiguration(
    public val jsonTokenTypeConfigurations: List<GetIndexUserTokenConfigurationJsonTokenTypeConfiguration>,
    public val jwtTokenTypeConfigurations: List<GetIndexUserTokenConfigurationJwtTokenTypeConfiguration>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kendra.outputs.GetIndexUserTokenConfiguration): GetIndexUserTokenConfiguration = GetIndexUserTokenConfiguration(
            jsonTokenTypeConfigurations = javaType.jsonTokenTypeConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kendra.kotlin.outputs.GetIndexUserTokenConfigurationJsonTokenTypeConfiguration.Companion.toKotlin(args0)
                })
            }),
            jwtTokenTypeConfigurations = javaType.jwtTokenTypeConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kendra.kotlin.outputs.GetIndexUserTokenConfigurationJwtTokenTypeConfiguration.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
