@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property claimRegex Regular expression that identifies the claim.
 * @property groupAttributeField The group attribute field.
 * @property issuer Issuer of the token.
 * @property keyLocation Location of the key. Valid values are `URL` or `SECRET_MANAGER`
 * @property secretsManagerArn ARN of the secret.
 * @property url Signing key URL.
 * @property userNameAttributeField The user name attribute field.
 */
public data class GetIndexUserTokenConfigurationJwtTokenTypeConfiguration(
    public val claimRegex: String,
    public val groupAttributeField: String,
    public val issuer: String,
    public val keyLocation: String,
    public val secretsManagerArn: String,
    public val url: String,
    public val userNameAttributeField: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kendra.outputs.GetIndexUserTokenConfigurationJwtTokenTypeConfiguration): GetIndexUserTokenConfigurationJwtTokenTypeConfiguration =
            GetIndexUserTokenConfigurationJwtTokenTypeConfiguration(
                claimRegex = javaType.claimRegex(),
                groupAttributeField = javaType.groupAttributeField(),
                issuer = javaType.issuer(),
                keyLocation = javaType.keyLocation(),
                secretsManagerArn = javaType.secretsManagerArn(),
                url = javaType.url(),
                userNameAttributeField = javaType.userNameAttributeField(),
            )
    }
}
