@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getQuerySuggestionsBlockList.
 * @property arn ARN of the block list.
 * @property createdAt Date-time a block list was created.
 * @property description Description for the block list.
 * @property errorMessage Error message containing details if there are issues processing the block list.
 * @property fileSizeBytes Current size of the block list text file in S3.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property indexId
 * @property itemCount Current number of valid, non-empty words or phrases in the block list text file.
 * @property name Name of the block list.
 * @property querySuggestionsBlockListId
 * @property roleArn ARN of a role with permission to access the S3 bucket that contains the block list. For more information, see [IAM Roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
 * @property sourceS3Paths S3 location of the block list input data. Detailed below.
 * @property status Current status of the block list. When the value is `ACTIVE`, the block list is ready for use.
 * @property tags Metadata that helps organize the block list you create.
 * @property updatedAt Date and time that the block list was last updated.
 */
public data class GetQuerySuggestionsBlockListResult(
    public val arn: String,
    public val createdAt: String,
    public val description: String,
    public val errorMessage: String,
    public val fileSizeBytes: Int,
    public val id: String,
    public val indexId: String,
    public val itemCount: Int,
    public val name: String,
    public val querySuggestionsBlockListId: String,
    public val roleArn: String,
    public val sourceS3Paths: List<GetQuerySuggestionsBlockListSourceS3Path>,
    public val status: String,
    public val tags: Map<String, String>,
    public val updatedAt: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kendra.outputs.GetQuerySuggestionsBlockListResult): GetQuerySuggestionsBlockListResult = GetQuerySuggestionsBlockListResult(
            arn = javaType.arn(),
            createdAt = javaType.createdAt(),
            description = javaType.description(),
            errorMessage = javaType.errorMessage(),
            fileSizeBytes = javaType.fileSizeBytes(),
            id = javaType.id(),
            indexId = javaType.indexId(),
            itemCount = javaType.itemCount(),
            name = javaType.name(),
            querySuggestionsBlockListId = javaType.querySuggestionsBlockListId(),
            roleArn = javaType.roleArn(),
            sourceS3Paths = javaType.sourceS3Paths().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kendra.kotlin.outputs.GetQuerySuggestionsBlockListSourceS3Path.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            updatedAt = javaType.updatedAt(),
        )
    }
}
