@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getThesaurus.
 * @property arn ARN of the Thesaurus.
 * @property createdAt Unix datetime that the Thesaurus was created.
 * @property description Description of the Thesaurus.
 * @property errorMessage When the `status` field value is `FAILED`, this contains a message that explains why.
 * @property fileSizeBytes Size of the Thesaurus file in bytes.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property indexId
 * @property name Name of the Thesaurus.
 * @property roleArn ARN of a role with permission to access the S3 bucket that contains the Thesaurus. For more information, see [IAM Roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
 * @property sourceS3Paths S3 location of the Thesaurus input data. Detailed below.
 * @property status Status of the Thesaurus. It is ready to use when the status is `ACTIVE`.
 * @property synonymRuleCount Number of synonym rules in the Thesaurus file.
 * @property tags Metadata that helps organize the Thesaurus you create.
 * @property termCount Number of unique terms in the Thesaurus file. For example, the synonyms `a,b,c` and `a=>d`, the term count would be 4.
 * @property thesaurusId
 * @property updatedAt Date and time that the Thesaurus was last updated.
 */
public data class GetThesaurusResult(
    public val arn: String,
    public val createdAt: String,
    public val description: String,
    public val errorMessage: String,
    public val fileSizeBytes: Int,
    public val id: String,
    public val indexId: String,
    public val name: String,
    public val roleArn: String,
    public val sourceS3Paths: List<GetThesaurusSourceS3Path>,
    public val status: String,
    public val synonymRuleCount: Int,
    public val tags: Map<String, String>,
    public val termCount: Int,
    public val thesaurusId: String,
    public val updatedAt: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kendra.outputs.GetThesaurusResult): GetThesaurusResult = GetThesaurusResult(
            arn = javaType.arn(),
            createdAt = javaType.createdAt(),
            description = javaType.description(),
            errorMessage = javaType.errorMessage(),
            fileSizeBytes = javaType.fileSizeBytes(),
            id = javaType.id(),
            indexId = javaType.indexId(),
            name = javaType.name(),
            roleArn = javaType.roleArn(),
            sourceS3Paths = javaType.sourceS3Paths().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kendra.kotlin.outputs.GetThesaurusSourceS3Path.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status(),
            synonymRuleCount = javaType.synonymRuleCount(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            termCount = javaType.termCount(),
            thesaurusId = javaType.thesaurusId(),
            updatedAt = javaType.updatedAt(),
        )
    }
}
