@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property queryCapacityUnits The amount of extra query capacity for an index and GetQuerySuggestions capacity. For more information, refer to [QueryCapacityUnits](https://docs.aws.amazon.com/kendra/latest/dg/API_CapacityUnitsConfiguration.html#Kendra-Type-CapacityUnitsConfiguration-QueryCapacityUnits).
 * @property storageCapacityUnits The amount of extra storage capacity for an index. A single capacity unit provides 30 GB of storage space or 100,000 documents, whichever is reached first. Minimum value of 0.
 */
public data class IndexCapacityUnits(
    public val queryCapacityUnits: Int? = null,
    public val storageCapacityUnits: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kendra.outputs.IndexCapacityUnits): IndexCapacityUnits = IndexCapacityUnits(
            queryCapacityUnits = javaType.queryCapacityUnits().map({ args0 -> args0 }).orElse(null),
            storageCapacityUnits = javaType.storageCapacityUnits().map({ args0 -> args0 }).orElse(null),
        )
    }
}
