@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property duration Specifies the time period that the boost applies to. For more information, refer to [Duration](https://docs.aws.amazon.com/kendra/latest/dg/API_Relevance.html#Kendra-Type-Relevance-Duration).
 * @property freshness Indicates that this field determines how "fresh" a document is. For more information, refer to [Freshness](https://docs.aws.amazon.com/kendra/latest/dg/API_Relevance.html#Kendra-Type-Relevance-Freshness).
 * @property importance The relative importance of the field in the search. Larger numbers provide more of a boost than smaller numbers. Minimum value of 1. Maximum value of 10.
 * @property rankOrder Determines how values should be interpreted. For more information, refer to [RankOrder](https://docs.aws.amazon.com/kendra/latest/dg/API_Relevance.html#Kendra-Type-Relevance-RankOrder).
 * @property valuesImportanceMap A list of values that should be given a different boost when they appear in the result list. For more information, refer to [ValueImportanceMap](https://docs.aws.amazon.com/kendra/latest/dg/API_Relevance.html#Kendra-Type-Relevance-ValueImportanceMap).
 */
public data class IndexDocumentMetadataConfigurationUpdateRelevance(
    public val duration: String? = null,
    public val freshness: Boolean? = null,
    public val importance: Int? = null,
    public val rankOrder: String? = null,
    public val valuesImportanceMap: Map<String, Int>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kendra.outputs.IndexDocumentMetadataConfigurationUpdateRelevance): IndexDocumentMetadataConfigurationUpdateRelevance =
            IndexDocumentMetadataConfigurationUpdateRelevance(
                duration = javaType.duration().map({ args0 -> args0 }).orElse(null),
                freshness = javaType.freshness().map({ args0 -> args0 }).orElse(null),
                importance = javaType.importance().map({ args0 -> args0 }).orElse(null),
                rankOrder = javaType.rankOrder().map({ args0 -> args0 }).orElse(null),
                valuesImportanceMap = javaType.valuesImportanceMap().map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap(),
            )
    }
}
