@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bucket The name of the S3 bucket that contains the file.
 * @property key The name of the file.
 * The following arguments are optional:
 */
public data class ThesaurusSourceS3Path(
    public val bucket: String,
    public val key: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kendra.outputs.ThesaurusSourceS3Path): ThesaurusSourceS3Path = ThesaurusSourceS3Path(
            bucket = javaType.bucket(),
            key = javaType.key(),
        )
    }
}
