@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.keyspaces.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Keyspace].
 */
@PulumiTagMarker
public class KeyspaceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: KeyspaceArgs = KeyspaceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend KeyspaceArgsBuilder.() -> Unit) {
        val builder = KeyspaceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Keyspace {
        val builtJavaResource = com.pulumi.aws.keyspaces.Keyspace(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Keyspace(builtJavaResource)
    }
}

/**
 * Provides a Keyspaces Keyspace.
 * More information about keyspaces can be found in the [Keyspaces User Guide](https://docs.aws.amazon.com/keyspaces/latest/devguide/what-is-keyspaces.html).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.keyspaces.Keyspace("example", {name: "my_keyspace"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.keyspaces.Keyspace("example", name="my_keyspace")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Keyspaces.Keyspace("example", new()
 *     {
 *         Name = "my_keyspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/keyspaces"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := keyspaces.NewKeyspace(ctx, "example", &keyspaces.KeyspaceArgs{
 * 			Name: pulumi.String("my_keyspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.keyspaces.Keyspace;
 * import com.pulumi.aws.keyspaces.KeyspaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Keyspace("example", KeyspaceArgs.builder()
 *             .name("my_keyspace")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:keyspaces:Keyspace
 *     properties:
 *       name: my_keyspace
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import a keyspace using the `name`. For example:
 * ```sh
 * $ pulumi import aws:keyspaces/keyspace:Keyspace example my_keyspace
 * ```
 */
public class Keyspace internal constructor(
    override val javaResource: com.pulumi.aws.keyspaces.Keyspace,
) : KotlinCustomResource(javaResource, KeyspaceMapper) {
    /**
     * The ARN of the keyspace.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The name of the keyspace to be created.
     * The following arguments are optional:
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object KeyspaceMapper : ResourceMapper<Keyspace> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.keyspaces.Keyspace::class == javaResource::class

    override fun map(javaResource: Resource): Keyspace = Keyspace(
        javaResource as
            com.pulumi.aws.keyspaces.Keyspace,
    )
}

/**
 * @see [Keyspace].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Keyspace].
 */
public suspend fun keyspace(name: String, block: suspend KeyspaceResourceBuilder.() -> Unit): Keyspace {
    val builder = KeyspaceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Keyspace].
 * @param name The _unique_ name of the resulting resource.
 */
public fun keyspace(name: String): Keyspace {
    val builder = KeyspaceResourceBuilder()
    builder.name(name)
    return builder.build()
}
