@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.keyspaces.kotlin

import com.pulumi.aws.keyspaces.kotlin.outputs.TableCapacitySpecification
import com.pulumi.aws.keyspaces.kotlin.outputs.TableClientSideTimestamps
import com.pulumi.aws.keyspaces.kotlin.outputs.TableComment
import com.pulumi.aws.keyspaces.kotlin.outputs.TableEncryptionSpecification
import com.pulumi.aws.keyspaces.kotlin.outputs.TablePointInTimeRecovery
import com.pulumi.aws.keyspaces.kotlin.outputs.TableSchemaDefinition
import com.pulumi.aws.keyspaces.kotlin.outputs.TableTtl
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.keyspaces.kotlin.outputs.TableCapacitySpecification.Companion.toKotlin as tableCapacitySpecificationToKotlin
import com.pulumi.aws.keyspaces.kotlin.outputs.TableClientSideTimestamps.Companion.toKotlin as tableClientSideTimestampsToKotlin
import com.pulumi.aws.keyspaces.kotlin.outputs.TableComment.Companion.toKotlin as tableCommentToKotlin
import com.pulumi.aws.keyspaces.kotlin.outputs.TableEncryptionSpecification.Companion.toKotlin as tableEncryptionSpecificationToKotlin
import com.pulumi.aws.keyspaces.kotlin.outputs.TablePointInTimeRecovery.Companion.toKotlin as tablePointInTimeRecoveryToKotlin
import com.pulumi.aws.keyspaces.kotlin.outputs.TableSchemaDefinition.Companion.toKotlin as tableSchemaDefinitionToKotlin
import com.pulumi.aws.keyspaces.kotlin.outputs.TableTtl.Companion.toKotlin as tableTtlToKotlin

/**
 * Builder for [Table].
 */
@PulumiTagMarker
public class TableResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TableArgs = TableArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TableArgsBuilder.() -> Unit) {
        val builder = TableArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Table {
        val builtJavaResource = com.pulumi.aws.keyspaces.Table(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Table(builtJavaResource)
    }
}

/**
 * Provides a Keyspaces Table.
 * More information about Keyspaces tables can be found in the [Keyspaces Developer Guide](https://docs.aws.amazon.com/keyspaces/latest/devguide/working-with-tables.html).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.keyspaces.Table("example", {
 *     keyspaceName: exampleAwsKeyspacesKeyspace.name,
 *     tableName: "my_table",
 *     schemaDefinition: {
 *         columns: [{
 *             name: "Message",
 *             type: "ASCII",
 *         }],
 *         partitionKeys: [{
 *             name: "Message",
 *         }],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.keyspaces.Table("example",
 *     keyspace_name=example_aws_keyspaces_keyspace["name"],
 *     table_name="my_table",
 *     schema_definition={
 *         "columns": [{
 *             "name": "Message",
 *             "type": "ASCII",
 *         }],
 *         "partition_keys": [{
 *             "name": "Message",
 *         }],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Keyspaces.Table("example", new()
 *     {
 *         KeyspaceName = exampleAwsKeyspacesKeyspace.Name,
 *         TableName = "my_table",
 *         SchemaDefinition = new Aws.Keyspaces.Inputs.TableSchemaDefinitionArgs
 *         {
 *             Columns = new[]
 *             {
 *                 new Aws.Keyspaces.Inputs.TableSchemaDefinitionColumnArgs
 *                 {
 *                     Name = "Message",
 *                     Type = "ASCII",
 *                 },
 *             },
 *             PartitionKeys = new[]
 *             {
 *                 new Aws.Keyspaces.Inputs.TableSchemaDefinitionPartitionKeyArgs
 *                 {
 *                     Name = "Message",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/keyspaces"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := keyspaces.NewTable(ctx, "example", &keyspaces.TableArgs{
 * 			KeyspaceName: pulumi.Any(exampleAwsKeyspacesKeyspace.Name),
 * 			TableName:    pulumi.String("my_table"),
 * 			SchemaDefinition: &keyspaces.TableSchemaDefinitionArgs{
 * 				Columns: keyspaces.TableSchemaDefinitionColumnArray{
 * 					&keyspaces.TableSchemaDefinitionColumnArgs{
 * 						Name: pulumi.String("Message"),
 * 						Type: pulumi.String("ASCII"),
 * 					},
 * 				},
 * 				PartitionKeys: keyspaces.TableSchemaDefinitionPartitionKeyArray{
 * 					&keyspaces.TableSchemaDefinitionPartitionKeyArgs{
 * 						Name: pulumi.String("Message"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.keyspaces.Table;
 * import com.pulumi.aws.keyspaces.TableArgs;
 * import com.pulumi.aws.keyspaces.inputs.TableSchemaDefinitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Table("example", TableArgs.builder()
 *             .keyspaceName(exampleAwsKeyspacesKeyspace.name())
 *             .tableName("my_table")
 *             .schemaDefinition(TableSchemaDefinitionArgs.builder()
 *                 .columns(TableSchemaDefinitionColumnArgs.builder()
 *                     .name("Message")
 *                     .type("ASCII")
 *                     .build())
 *                 .partitionKeys(TableSchemaDefinitionPartitionKeyArgs.builder()
 *                     .name("Message")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:keyspaces:Table
 *     properties:
 *       keyspaceName: ${exampleAwsKeyspacesKeyspace.name}
 *       tableName: my_table
 *       schemaDefinition:
 *         columns:
 *           - name: Message
 *             type: ASCII
 *         partitionKeys:
 *           - name: Message
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import a table using the `keyspace_name` and `table_name` separated by `/`. For example:
 * ```sh
 * $ pulumi import aws:keyspaces/table:Table example my_keyspace/my_table
 * ```
 */
public class Table internal constructor(
    override val javaResource: com.pulumi.aws.keyspaces.Table,
) : KotlinCustomResource(javaResource, TableMapper) {
    /**
     * The ARN of the table.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Specifies the read/write throughput capacity mode for the table.
     */
    public val capacitySpecification: Output<TableCapacitySpecification>
        get() = javaResource.capacitySpecification().applyValue({ args0 ->
            args0.let({ args0 ->
                tableCapacitySpecificationToKotlin(args0)
            })
        })

    /**
     * Enables client-side timestamps for the table. By default, the setting is disabled.
     */
    public val clientSideTimestamps: Output<TableClientSideTimestamps>?
        get() = javaResource.clientSideTimestamps().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> tableClientSideTimestampsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * A description of the table.
     */
    public val comment: Output<TableComment>
        get() = javaResource.comment().applyValue({ args0 ->
            args0.let({ args0 ->
                tableCommentToKotlin(args0)
            })
        })

    /**
     * The default Time to Live setting in seconds for the table. More information can be found in the [Developer Guide](https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL-how-it-works.html#ttl-howitworks_default_ttl).
     */
    public val defaultTimeToLive: Output<Int>?
        get() = javaResource.defaultTimeToLive().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies how the encryption key for encryption at rest is managed for the table. More information can be found in the [Developer Guide](https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html).
     */
    public val encryptionSpecification: Output<TableEncryptionSpecification>
        get() = javaResource.encryptionSpecification().applyValue({ args0 ->
            args0.let({ args0 ->
                tableEncryptionSpecificationToKotlin(args0)
            })
        })

    /**
     * The name of the keyspace that the table is going to be created in.
     */
    public val keyspaceName: Output<String>
        get() = javaResource.keyspaceName().applyValue({ args0 -> args0 })

    /**
     * Specifies if point-in-time recovery is enabled or disabled for the table. More information can be found in the [Developer Guide](https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html).
     */
    public val pointInTimeRecovery: Output<TablePointInTimeRecovery>
        get() = javaResource.pointInTimeRecovery().applyValue({ args0 ->
            args0.let({ args0 ->
                tablePointInTimeRecoveryToKotlin(args0)
            })
        })

    /**
     * Describes the schema of the table.
     */
    public val schemaDefinition: Output<TableSchemaDefinition>
        get() = javaResource.schemaDefinition().applyValue({ args0 ->
            args0.let({ args0 ->
                tableSchemaDefinitionToKotlin(args0)
            })
        })

    /**
     * The name of the table.
     * The following arguments are optional:
     */
    public val tableName: Output<String>
        get() = javaResource.tableName().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Enables Time to Live custom settings for the table. More information can be found in the [Developer Guide](https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL.html).
     */
    public val ttl: Output<TableTtl>?
        get() = javaResource.ttl().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    tableTtlToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object TableMapper : ResourceMapper<Table> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.keyspaces.Table::class == javaResource::class

    override fun map(javaResource: Resource): Table = Table(
        javaResource as
            com.pulumi.aws.keyspaces.Table,
    )
}

/**
 * @see [Table].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Table].
 */
public suspend fun table(name: String, block: suspend TableResourceBuilder.() -> Unit): Table {
    val builder = TableResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Table].
 * @param name The _unique_ name of the resulting resource.
 */
public fun table(name: String): Table {
    val builder = TableResourceBuilder()
    builder.name(name)
    return builder.build()
}
