@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.keyspaces.kotlin

import com.pulumi.aws.keyspaces.TableArgs.builder
import com.pulumi.aws.keyspaces.kotlin.inputs.TableCapacitySpecificationArgs
import com.pulumi.aws.keyspaces.kotlin.inputs.TableCapacitySpecificationArgsBuilder
import com.pulumi.aws.keyspaces.kotlin.inputs.TableClientSideTimestampsArgs
import com.pulumi.aws.keyspaces.kotlin.inputs.TableClientSideTimestampsArgsBuilder
import com.pulumi.aws.keyspaces.kotlin.inputs.TableCommentArgs
import com.pulumi.aws.keyspaces.kotlin.inputs.TableCommentArgsBuilder
import com.pulumi.aws.keyspaces.kotlin.inputs.TableEncryptionSpecificationArgs
import com.pulumi.aws.keyspaces.kotlin.inputs.TableEncryptionSpecificationArgsBuilder
import com.pulumi.aws.keyspaces.kotlin.inputs.TablePointInTimeRecoveryArgs
import com.pulumi.aws.keyspaces.kotlin.inputs.TablePointInTimeRecoveryArgsBuilder
import com.pulumi.aws.keyspaces.kotlin.inputs.TableSchemaDefinitionArgs
import com.pulumi.aws.keyspaces.kotlin.inputs.TableSchemaDefinitionArgsBuilder
import com.pulumi.aws.keyspaces.kotlin.inputs.TableTtlArgs
import com.pulumi.aws.keyspaces.kotlin.inputs.TableTtlArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Keyspaces Table.
 * More information about Keyspaces tables can be found in the [Keyspaces Developer Guide](https://docs.aws.amazon.com/keyspaces/latest/devguide/working-with-tables.html).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.keyspaces.Table("example", {
 *     keyspaceName: exampleAwsKeyspacesKeyspace.name,
 *     tableName: "my_table",
 *     schemaDefinition: {
 *         columns: [{
 *             name: "Message",
 *             type: "ASCII",
 *         }],
 *         partitionKeys: [{
 *             name: "Message",
 *         }],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.keyspaces.Table("example",
 *     keyspace_name=example_aws_keyspaces_keyspace["name"],
 *     table_name="my_table",
 *     schema_definition={
 *         "columns": [{
 *             "name": "Message",
 *             "type": "ASCII",
 *         }],
 *         "partition_keys": [{
 *             "name": "Message",
 *         }],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Keyspaces.Table("example", new()
 *     {
 *         KeyspaceName = exampleAwsKeyspacesKeyspace.Name,
 *         TableName = "my_table",
 *         SchemaDefinition = new Aws.Keyspaces.Inputs.TableSchemaDefinitionArgs
 *         {
 *             Columns = new[]
 *             {
 *                 new Aws.Keyspaces.Inputs.TableSchemaDefinitionColumnArgs
 *                 {
 *                     Name = "Message",
 *                     Type = "ASCII",
 *                 },
 *             },
 *             PartitionKeys = new[]
 *             {
 *                 new Aws.Keyspaces.Inputs.TableSchemaDefinitionPartitionKeyArgs
 *                 {
 *                     Name = "Message",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/keyspaces"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := keyspaces.NewTable(ctx, "example", &keyspaces.TableArgs{
 * 			KeyspaceName: pulumi.Any(exampleAwsKeyspacesKeyspace.Name),
 * 			TableName:    pulumi.String("my_table"),
 * 			SchemaDefinition: &keyspaces.TableSchemaDefinitionArgs{
 * 				Columns: keyspaces.TableSchemaDefinitionColumnArray{
 * 					&keyspaces.TableSchemaDefinitionColumnArgs{
 * 						Name: pulumi.String("Message"),
 * 						Type: pulumi.String("ASCII"),
 * 					},
 * 				},
 * 				PartitionKeys: keyspaces.TableSchemaDefinitionPartitionKeyArray{
 * 					&keyspaces.TableSchemaDefinitionPartitionKeyArgs{
 * 						Name: pulumi.String("Message"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.keyspaces.Table;
 * import com.pulumi.aws.keyspaces.TableArgs;
 * import com.pulumi.aws.keyspaces.inputs.TableSchemaDefinitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Table("example", TableArgs.builder()
 *             .keyspaceName(exampleAwsKeyspacesKeyspace.name())
 *             .tableName("my_table")
 *             .schemaDefinition(TableSchemaDefinitionArgs.builder()
 *                 .columns(TableSchemaDefinitionColumnArgs.builder()
 *                     .name("Message")
 *                     .type("ASCII")
 *                     .build())
 *                 .partitionKeys(TableSchemaDefinitionPartitionKeyArgs.builder()
 *                     .name("Message")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:keyspaces:Table
 *     properties:
 *       keyspaceName: ${exampleAwsKeyspacesKeyspace.name}
 *       tableName: my_table
 *       schemaDefinition:
 *         columns:
 *           - name: Message
 *             type: ASCII
 *         partitionKeys:
 *           - name: Message
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import a table using the `keyspace_name` and `table_name` separated by `/`. For example:
 * ```sh
 * $ pulumi import aws:keyspaces/table:Table example my_keyspace/my_table
 * ```
 * @property capacitySpecification Specifies the read/write throughput capacity mode for the table.
 * @property clientSideTimestamps Enables client-side timestamps for the table. By default, the setting is disabled.
 * @property comment A description of the table.
 * @property defaultTimeToLive The default Time to Live setting in seconds for the table. More information can be found in the [Developer Guide](https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL-how-it-works.html#ttl-howitworks_default_ttl).
 * @property encryptionSpecification Specifies how the encryption key for encryption at rest is managed for the table. More information can be found in the [Developer Guide](https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html).
 * @property keyspaceName The name of the keyspace that the table is going to be created in.
 * @property pointInTimeRecovery Specifies if point-in-time recovery is enabled or disabled for the table. More information can be found in the [Developer Guide](https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html).
 * @property schemaDefinition Describes the schema of the table.
 * @property tableName The name of the table.
 * The following arguments are optional:
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property ttl Enables Time to Live custom settings for the table. More information can be found in the [Developer Guide](https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL.html).
 */
public data class TableArgs(
    public val capacitySpecification: Output<TableCapacitySpecificationArgs>? = null,
    public val clientSideTimestamps: Output<TableClientSideTimestampsArgs>? = null,
    public val comment: Output<TableCommentArgs>? = null,
    public val defaultTimeToLive: Output<Int>? = null,
    public val encryptionSpecification: Output<TableEncryptionSpecificationArgs>? = null,
    public val keyspaceName: Output<String>? = null,
    public val pointInTimeRecovery: Output<TablePointInTimeRecoveryArgs>? = null,
    public val schemaDefinition: Output<TableSchemaDefinitionArgs>? = null,
    public val tableName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val ttl: Output<TableTtlArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.keyspaces.TableArgs> {
    override fun toJava(): com.pulumi.aws.keyspaces.TableArgs =
        com.pulumi.aws.keyspaces.TableArgs.builder()
            .capacitySpecification(
                capacitySpecification?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .clientSideTimestamps(
                clientSideTimestamps?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .comment(comment?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .defaultTimeToLive(defaultTimeToLive?.applyValue({ args0 -> args0 }))
            .encryptionSpecification(
                encryptionSpecification?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .keyspaceName(keyspaceName?.applyValue({ args0 -> args0 }))
            .pointInTimeRecovery(
                pointInTimeRecovery?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .schemaDefinition(schemaDefinition?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tableName(tableName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .ttl(ttl?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [TableArgs].
 */
@PulumiTagMarker
public class TableArgsBuilder internal constructor() {
    private var capacitySpecification: Output<TableCapacitySpecificationArgs>? = null

    private var clientSideTimestamps: Output<TableClientSideTimestampsArgs>? = null

    private var comment: Output<TableCommentArgs>? = null

    private var defaultTimeToLive: Output<Int>? = null

    private var encryptionSpecification: Output<TableEncryptionSpecificationArgs>? = null

    private var keyspaceName: Output<String>? = null

    private var pointInTimeRecovery: Output<TablePointInTimeRecoveryArgs>? = null

    private var schemaDefinition: Output<TableSchemaDefinitionArgs>? = null

    private var tableName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var ttl: Output<TableTtlArgs>? = null

    /**
     * @param value Specifies the read/write throughput capacity mode for the table.
     */
    @JvmName("dduvqesqlrrcvwjk")
    public suspend fun capacitySpecification(`value`: Output<TableCapacitySpecificationArgs>) {
        this.capacitySpecification = value
    }

    /**
     * @param value Enables client-side timestamps for the table. By default, the setting is disabled.
     */
    @JvmName("uhylhtbrpclcusof")
    public suspend fun clientSideTimestamps(`value`: Output<TableClientSideTimestampsArgs>) {
        this.clientSideTimestamps = value
    }

    /**
     * @param value A description of the table.
     */
    @JvmName("fodvqwjrstgvmkdm")
    public suspend fun comment(`value`: Output<TableCommentArgs>) {
        this.comment = value
    }

    /**
     * @param value The default Time to Live setting in seconds for the table. More information can be found in the [Developer Guide](https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL-how-it-works.html#ttl-howitworks_default_ttl).
     */
    @JvmName("olffjytbjidahtkw")
    public suspend fun defaultTimeToLive(`value`: Output<Int>) {
        this.defaultTimeToLive = value
    }

    /**
     * @param value Specifies how the encryption key for encryption at rest is managed for the table. More information can be found in the [Developer Guide](https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html).
     */
    @JvmName("nucivorbillgctke")
    public suspend fun encryptionSpecification(`value`: Output<TableEncryptionSpecificationArgs>) {
        this.encryptionSpecification = value
    }

    /**
     * @param value The name of the keyspace that the table is going to be created in.
     */
    @JvmName("drwmnanxsvkujbmg")
    public suspend fun keyspaceName(`value`: Output<String>) {
        this.keyspaceName = value
    }

    /**
     * @param value Specifies if point-in-time recovery is enabled or disabled for the table. More information can be found in the [Developer Guide](https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html).
     */
    @JvmName("lcpskmxewxexpxmh")
    public suspend fun pointInTimeRecovery(`value`: Output<TablePointInTimeRecoveryArgs>) {
        this.pointInTimeRecovery = value
    }

    /**
     * @param value Describes the schema of the table.
     */
    @JvmName("slhnvvuofqrrogtx")
    public suspend fun schemaDefinition(`value`: Output<TableSchemaDefinitionArgs>) {
        this.schemaDefinition = value
    }

    /**
     * @param value The name of the table.
     * The following arguments are optional:
     */
    @JvmName("bymwyeewgnlnljhh")
    public suspend fun tableName(`value`: Output<String>) {
        this.tableName = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pfdccvharsxufvhl")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Enables Time to Live custom settings for the table. More information can be found in the [Developer Guide](https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL.html).
     */
    @JvmName("saknxqwkwxgepsmn")
    public suspend fun ttl(`value`: Output<TableTtlArgs>) {
        this.ttl = value
    }

    /**
     * @param value Specifies the read/write throughput capacity mode for the table.
     */
    @JvmName("qeiehfuedebyaysh")
    public suspend fun capacitySpecification(`value`: TableCapacitySpecificationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacitySpecification = mapped
    }

    /**
     * @param argument Specifies the read/write throughput capacity mode for the table.
     */
    @JvmName("nwcmatophwjtsabe")
    public suspend fun capacitySpecification(argument: suspend TableCapacitySpecificationArgsBuilder.() -> Unit) {
        val toBeMapped = TableCapacitySpecificationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.capacitySpecification = mapped
    }

    /**
     * @param value Enables client-side timestamps for the table. By default, the setting is disabled.
     */
    @JvmName("ipjlgemmpskdohhc")
    public suspend fun clientSideTimestamps(`value`: TableClientSideTimestampsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientSideTimestamps = mapped
    }

    /**
     * @param argument Enables client-side timestamps for the table. By default, the setting is disabled.
     */
    @JvmName("pkbrkfaphwtojkkp")
    public suspend fun clientSideTimestamps(argument: suspend TableClientSideTimestampsArgsBuilder.() -> Unit) {
        val toBeMapped = TableClientSideTimestampsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.clientSideTimestamps = mapped
    }

    /**
     * @param value A description of the table.
     */
    @JvmName("ayqqorntfgtcddca")
    public suspend fun comment(`value`: TableCommentArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.comment = mapped
    }

    /**
     * @param argument A description of the table.
     */
    @JvmName("bvrebhiveleyksxb")
    public suspend fun comment(argument: suspend TableCommentArgsBuilder.() -> Unit) {
        val toBeMapped = TableCommentArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.comment = mapped
    }

    /**
     * @param value The default Time to Live setting in seconds for the table. More information can be found in the [Developer Guide](https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL-how-it-works.html#ttl-howitworks_default_ttl).
     */
    @JvmName("mniiwbfgwgipbieo")
    public suspend fun defaultTimeToLive(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultTimeToLive = mapped
    }

    /**
     * @param value Specifies how the encryption key for encryption at rest is managed for the table. More information can be found in the [Developer Guide](https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html).
     */
    @JvmName("deaxvrmwcbyydtrc")
    public suspend fun encryptionSpecification(`value`: TableEncryptionSpecificationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionSpecification = mapped
    }

    /**
     * @param argument Specifies how the encryption key for encryption at rest is managed for the table. More information can be found in the [Developer Guide](https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html).
     */
    @JvmName("jreqhgmtlycumnho")
    public suspend fun encryptionSpecification(argument: suspend TableEncryptionSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped = TableEncryptionSpecificationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryptionSpecification = mapped
    }

    /**
     * @param value The name of the keyspace that the table is going to be created in.
     */
    @JvmName("wfolscejatqmqggp")
    public suspend fun keyspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyspaceName = mapped
    }

    /**
     * @param value Specifies if point-in-time recovery is enabled or disabled for the table. More information can be found in the [Developer Guide](https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html).
     */
    @JvmName("pbljxodccjuwyfws")
    public suspend fun pointInTimeRecovery(`value`: TablePointInTimeRecoveryArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pointInTimeRecovery = mapped
    }

    /**
     * @param argument Specifies if point-in-time recovery is enabled or disabled for the table. More information can be found in the [Developer Guide](https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html).
     */
    @JvmName("soaeynryhbhoocdb")
    public suspend fun pointInTimeRecovery(argument: suspend TablePointInTimeRecoveryArgsBuilder.() -> Unit) {
        val toBeMapped = TablePointInTimeRecoveryArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.pointInTimeRecovery = mapped
    }

    /**
     * @param value Describes the schema of the table.
     */
    @JvmName("lbahdicmuglgvfkb")
    public suspend fun schemaDefinition(`value`: TableSchemaDefinitionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schemaDefinition = mapped
    }

    /**
     * @param argument Describes the schema of the table.
     */
    @JvmName("yshxwfvkuwdfwgea")
    public suspend fun schemaDefinition(argument: suspend TableSchemaDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = TableSchemaDefinitionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.schemaDefinition = mapped
    }

    /**
     * @param value The name of the table.
     * The following arguments are optional:
     */
    @JvmName("pogbeycvadutfqip")
    public suspend fun tableName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableName = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vimswlaqmicxxfmm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("olnxdnbrdpunhaxf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Enables Time to Live custom settings for the table. More information can be found in the [Developer Guide](https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL.html).
     */
    @JvmName("cdripyogvlwylqmb")
    public suspend fun ttl(`value`: TableTtlArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ttl = mapped
    }

    /**
     * @param argument Enables Time to Live custom settings for the table. More information can be found in the [Developer Guide](https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL.html).
     */
    @JvmName("vxkregdaqxsarifg")
    public suspend fun ttl(argument: suspend TableTtlArgsBuilder.() -> Unit) {
        val toBeMapped = TableTtlArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ttl = mapped
    }

    internal fun build(): TableArgs = TableArgs(
        capacitySpecification = capacitySpecification,
        clientSideTimestamps = clientSideTimestamps,
        comment = comment,
        defaultTimeToLive = defaultTimeToLive,
        encryptionSpecification = encryptionSpecification,
        keyspaceName = keyspaceName,
        pointInTimeRecovery = pointInTimeRecovery,
        schemaDefinition = schemaDefinition,
        tableName = tableName,
        tags = tags,
        ttl = ttl,
    )
}
