@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.keyspaces.kotlin.inputs

import com.pulumi.aws.keyspaces.inputs.TableEncryptionSpecificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property kmsKeyIdentifier The Amazon Resource Name (ARN) of the customer managed KMS key.
 * @property type The encryption option specified for the table. Valid values: `AWS_OWNED_KMS_KEY`, `CUSTOMER_MANAGED_KMS_KEY`. The default value is `AWS_OWNED_KMS_KEY`.
 */
public data class TableEncryptionSpecificationArgs(
    public val kmsKeyIdentifier: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.keyspaces.inputs.TableEncryptionSpecificationArgs> {
    override fun toJava(): com.pulumi.aws.keyspaces.inputs.TableEncryptionSpecificationArgs =
        com.pulumi.aws.keyspaces.inputs.TableEncryptionSpecificationArgs.builder()
            .kmsKeyIdentifier(kmsKeyIdentifier?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TableEncryptionSpecificationArgs].
 */
@PulumiTagMarker
public class TableEncryptionSpecificationArgsBuilder internal constructor() {
    private var kmsKeyIdentifier: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the customer managed KMS key.
     */
    @JvmName("fpaevwmwjnnvbcky")
    public suspend fun kmsKeyIdentifier(`value`: Output<String>) {
        this.kmsKeyIdentifier = value
    }

    /**
     * @param value The encryption option specified for the table. Valid values: `AWS_OWNED_KMS_KEY`, `CUSTOMER_MANAGED_KMS_KEY`. The default value is `AWS_OWNED_KMS_KEY`.
     */
    @JvmName("oocqlvlrpyvqwieh")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the customer managed KMS key.
     */
    @JvmName("elaopjltrqdpcdjm")
    public suspend fun kmsKeyIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyIdentifier = mapped
    }

    /**
     * @param value The encryption option specified for the table. Valid values: `AWS_OWNED_KMS_KEY`, `CUSTOMER_MANAGED_KMS_KEY`. The default value is `AWS_OWNED_KMS_KEY`.
     */
    @JvmName("mprngsmhqcwwiicy")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): TableEncryptionSpecificationArgs = TableEncryptionSpecificationArgs(
        kmsKeyIdentifier = kmsKeyIdentifier,
        type = type,
    )
}
