@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.keyspaces.kotlin.inputs

import com.pulumi.aws.keyspaces.inputs.TableSchemaDefinitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property clusteringKeys The columns that are part of the clustering key of the table.
 * @property columns The regular columns of the table.
 * @property partitionKeys The columns that are part of the partition key of the table .
 * @property staticColumns The columns that have been defined as `STATIC`. Static columns store values that are shared by all rows in the same partition.
 */
public data class TableSchemaDefinitionArgs(
    public val clusteringKeys: Output<List<TableSchemaDefinitionClusteringKeyArgs>>? = null,
    public val columns: Output<List<TableSchemaDefinitionColumnArgs>>,
    public val partitionKeys: Output<List<TableSchemaDefinitionPartitionKeyArgs>>,
    public val staticColumns: Output<List<TableSchemaDefinitionStaticColumnArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.keyspaces.inputs.TableSchemaDefinitionArgs> {
    override fun toJava(): com.pulumi.aws.keyspaces.inputs.TableSchemaDefinitionArgs =
        com.pulumi.aws.keyspaces.inputs.TableSchemaDefinitionArgs.builder()
            .clusteringKeys(
                clusteringKeys?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .columns(
                columns.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .partitionKeys(
                partitionKeys.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .staticColumns(
                staticColumns?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [TableSchemaDefinitionArgs].
 */
@PulumiTagMarker
public class TableSchemaDefinitionArgsBuilder internal constructor() {
    private var clusteringKeys: Output<List<TableSchemaDefinitionClusteringKeyArgs>>? = null

    private var columns: Output<List<TableSchemaDefinitionColumnArgs>>? = null

    private var partitionKeys: Output<List<TableSchemaDefinitionPartitionKeyArgs>>? = null

    private var staticColumns: Output<List<TableSchemaDefinitionStaticColumnArgs>>? = null

    /**
     * @param value The columns that are part of the clustering key of the table.
     */
    @JvmName("iqytxbbskuchdjnx")
    public suspend fun clusteringKeys(`value`: Output<List<TableSchemaDefinitionClusteringKeyArgs>>) {
        this.clusteringKeys = value
    }

    @JvmName("uiffutvsqcjlfcey")
    public suspend fun clusteringKeys(vararg values: Output<TableSchemaDefinitionClusteringKeyArgs>) {
        this.clusteringKeys = Output.all(values.asList())
    }

    /**
     * @param values The columns that are part of the clustering key of the table.
     */
    @JvmName("suwxujnriyeaxdnq")
    public suspend fun clusteringKeys(values: List<Output<TableSchemaDefinitionClusteringKeyArgs>>) {
        this.clusteringKeys = Output.all(values)
    }

    /**
     * @param value The regular columns of the table.
     */
    @JvmName("qmnqejbjwctiuliy")
    public suspend fun columns(`value`: Output<List<TableSchemaDefinitionColumnArgs>>) {
        this.columns = value
    }

    @JvmName("byfkgrlqlxfvkcip")
    public suspend fun columns(vararg values: Output<TableSchemaDefinitionColumnArgs>) {
        this.columns = Output.all(values.asList())
    }

    /**
     * @param values The regular columns of the table.
     */
    @JvmName("gfnpvmyavqfkvrbu")
    public suspend fun columns(values: List<Output<TableSchemaDefinitionColumnArgs>>) {
        this.columns = Output.all(values)
    }

    /**
     * @param value The columns that are part of the partition key of the table .
     */
    @JvmName("chagprefnrnxqvjt")
    public suspend fun partitionKeys(`value`: Output<List<TableSchemaDefinitionPartitionKeyArgs>>) {
        this.partitionKeys = value
    }

    @JvmName("whnfhxqwpyvkfuvx")
    public suspend fun partitionKeys(vararg values: Output<TableSchemaDefinitionPartitionKeyArgs>) {
        this.partitionKeys = Output.all(values.asList())
    }

    /**
     * @param values The columns that are part of the partition key of the table .
     */
    @JvmName("ffsgvpexwcmefpci")
    public suspend fun partitionKeys(values: List<Output<TableSchemaDefinitionPartitionKeyArgs>>) {
        this.partitionKeys = Output.all(values)
    }

    /**
     * @param value The columns that have been defined as `STATIC`. Static columns store values that are shared by all rows in the same partition.
     */
    @JvmName("bpcpngrbovqapfkb")
    public suspend fun staticColumns(`value`: Output<List<TableSchemaDefinitionStaticColumnArgs>>) {
        this.staticColumns = value
    }

    @JvmName("ucgyadsqucljituv")
    public suspend fun staticColumns(vararg values: Output<TableSchemaDefinitionStaticColumnArgs>) {
        this.staticColumns = Output.all(values.asList())
    }

    /**
     * @param values The columns that have been defined as `STATIC`. Static columns store values that are shared by all rows in the same partition.
     */
    @JvmName("kjinkeppcfudfjaw")
    public suspend fun staticColumns(values: List<Output<TableSchemaDefinitionStaticColumnArgs>>) {
        this.staticColumns = Output.all(values)
    }

    /**
     * @param value The columns that are part of the clustering key of the table.
     */
    @JvmName("jkgyblduvrqcxdsa")
    public suspend fun clusteringKeys(`value`: List<TableSchemaDefinitionClusteringKeyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusteringKeys = mapped
    }

    /**
     * @param argument The columns that are part of the clustering key of the table.
     */
    @JvmName("lpdthhskrgnetxnl")
    public suspend fun clusteringKeys(argument: List<suspend TableSchemaDefinitionClusteringKeyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TableSchemaDefinitionClusteringKeyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.clusteringKeys = mapped
    }

    /**
     * @param argument The columns that are part of the clustering key of the table.
     */
    @JvmName("jdkfskryxvpbqblg")
    public suspend fun clusteringKeys(vararg argument: suspend TableSchemaDefinitionClusteringKeyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TableSchemaDefinitionClusteringKeyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.clusteringKeys = mapped
    }

    /**
     * @param argument The columns that are part of the clustering key of the table.
     */
    @JvmName("fajnpgwyowmygnmc")
    public suspend fun clusteringKeys(argument: suspend TableSchemaDefinitionClusteringKeyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            TableSchemaDefinitionClusteringKeyArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.clusteringKeys = mapped
    }

    /**
     * @param values The columns that are part of the clustering key of the table.
     */
    @JvmName("icqanjoosxufxoyv")
    public suspend fun clusteringKeys(vararg values: TableSchemaDefinitionClusteringKeyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clusteringKeys = mapped
    }

    /**
     * @param value The regular columns of the table.
     */
    @JvmName("wapkolocpdspawws")
    public suspend fun columns(`value`: List<TableSchemaDefinitionColumnArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.columns = mapped
    }

    /**
     * @param argument The regular columns of the table.
     */
    @JvmName("glduoubxnkygmukk")
    public suspend fun columns(argument: List<suspend TableSchemaDefinitionColumnArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TableSchemaDefinitionColumnArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.columns = mapped
    }

    /**
     * @param argument The regular columns of the table.
     */
    @JvmName("rhasmyiwfrphmoci")
    public suspend fun columns(vararg argument: suspend TableSchemaDefinitionColumnArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TableSchemaDefinitionColumnArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.columns = mapped
    }

    /**
     * @param argument The regular columns of the table.
     */
    @JvmName("jtlmjebqeeicffpw")
    public suspend fun columns(argument: suspend TableSchemaDefinitionColumnArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            TableSchemaDefinitionColumnArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.columns = mapped
    }

    /**
     * @param values The regular columns of the table.
     */
    @JvmName("kdwfohwxdahashsx")
    public suspend fun columns(vararg values: TableSchemaDefinitionColumnArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.columns = mapped
    }

    /**
     * @param value The columns that are part of the partition key of the table .
     */
    @JvmName("sxrbtuobbltpiypn")
    public suspend fun partitionKeys(`value`: List<TableSchemaDefinitionPartitionKeyArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.partitionKeys = mapped
    }

    /**
     * @param argument The columns that are part of the partition key of the table .
     */
    @JvmName("pbhufywenmyrtapf")
    public suspend fun partitionKeys(argument: List<suspend TableSchemaDefinitionPartitionKeyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TableSchemaDefinitionPartitionKeyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.partitionKeys = mapped
    }

    /**
     * @param argument The columns that are part of the partition key of the table .
     */
    @JvmName("bbmxsxjyqwdoejbf")
    public suspend fun partitionKeys(vararg argument: suspend TableSchemaDefinitionPartitionKeyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TableSchemaDefinitionPartitionKeyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.partitionKeys = mapped
    }

    /**
     * @param argument The columns that are part of the partition key of the table .
     */
    @JvmName("varfxiwpnxjordgn")
    public suspend fun partitionKeys(argument: suspend TableSchemaDefinitionPartitionKeyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            TableSchemaDefinitionPartitionKeyArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.partitionKeys = mapped
    }

    /**
     * @param values The columns that are part of the partition key of the table .
     */
    @JvmName("gqbaqiatammlgmky")
    public suspend fun partitionKeys(vararg values: TableSchemaDefinitionPartitionKeyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.partitionKeys = mapped
    }

    /**
     * @param value The columns that have been defined as `STATIC`. Static columns store values that are shared by all rows in the same partition.
     */
    @JvmName("dtbtcdkwyjfmxqep")
    public suspend fun staticColumns(`value`: List<TableSchemaDefinitionStaticColumnArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.staticColumns = mapped
    }

    /**
     * @param argument The columns that have been defined as `STATIC`. Static columns store values that are shared by all rows in the same partition.
     */
    @JvmName("rycxonijoqnqgnbt")
    public suspend fun staticColumns(argument: List<suspend TableSchemaDefinitionStaticColumnArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TableSchemaDefinitionStaticColumnArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.staticColumns = mapped
    }

    /**
     * @param argument The columns that have been defined as `STATIC`. Static columns store values that are shared by all rows in the same partition.
     */
    @JvmName("rqshxujunqkkfqwk")
    public suspend fun staticColumns(vararg argument: suspend TableSchemaDefinitionStaticColumnArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TableSchemaDefinitionStaticColumnArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.staticColumns = mapped
    }

    /**
     * @param argument The columns that have been defined as `STATIC`. Static columns store values that are shared by all rows in the same partition.
     */
    @JvmName("xnpxcdgyenjkhgfq")
    public suspend fun staticColumns(argument: suspend TableSchemaDefinitionStaticColumnArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            TableSchemaDefinitionStaticColumnArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.staticColumns = mapped
    }

    /**
     * @param values The columns that have been defined as `STATIC`. Static columns store values that are shared by all rows in the same partition.
     */
    @JvmName("nhvksdisisvvnlxx")
    public suspend fun staticColumns(vararg values: TableSchemaDefinitionStaticColumnArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.staticColumns = mapped
    }

    internal fun build(): TableSchemaDefinitionArgs = TableSchemaDefinitionArgs(
        clusteringKeys = clusteringKeys,
        columns = columns ?: throw PulumiNullFieldException("columns"),
        partitionKeys = partitionKeys ?: throw PulumiNullFieldException("partitionKeys"),
        staticColumns = staticColumns,
    )
}
