@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.keyspaces.kotlin.inputs

import com.pulumi.aws.keyspaces.inputs.TableSchemaDefinitionClusteringKeyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of the clustering key column.
 * @property orderBy The order modifier. Valid values: `ASC`, `DESC`.
 */
public data class TableSchemaDefinitionClusteringKeyArgs(
    public val name: Output<String>,
    public val orderBy: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.keyspaces.inputs.TableSchemaDefinitionClusteringKeyArgs> {
    override fun toJava(): com.pulumi.aws.keyspaces.inputs.TableSchemaDefinitionClusteringKeyArgs =
        com.pulumi.aws.keyspaces.inputs.TableSchemaDefinitionClusteringKeyArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .orderBy(orderBy.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TableSchemaDefinitionClusteringKeyArgs].
 */
@PulumiTagMarker
public class TableSchemaDefinitionClusteringKeyArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var orderBy: Output<String>? = null

    /**
     * @param value The name of the clustering key column.
     */
    @JvmName("tehwckjdpplpcklb")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The order modifier. Valid values: `ASC`, `DESC`.
     */
    @JvmName("vyqflpafkdelhhjk")
    public suspend fun orderBy(`value`: Output<String>) {
        this.orderBy = value
    }

    /**
     * @param value The name of the clustering key column.
     */
    @JvmName("gqtsncqwvctwjatg")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The order modifier. Valid values: `ASC`, `DESC`.
     */
    @JvmName("phgslbqsvbdfoxdg")
    public suspend fun orderBy(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.orderBy = mapped
    }

    internal fun build(): TableSchemaDefinitionClusteringKeyArgs =
        TableSchemaDefinitionClusteringKeyArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            orderBy = orderBy ?: throw PulumiNullFieldException("orderBy"),
        )
}
