@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.keyspaces.kotlin.inputs

import com.pulumi.aws.keyspaces.inputs.TableSchemaDefinitionPartitionKeyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of the partition key column.
 */
public data class TableSchemaDefinitionPartitionKeyArgs(
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.keyspaces.inputs.TableSchemaDefinitionPartitionKeyArgs> {
    override fun toJava(): com.pulumi.aws.keyspaces.inputs.TableSchemaDefinitionPartitionKeyArgs =
        com.pulumi.aws.keyspaces.inputs.TableSchemaDefinitionPartitionKeyArgs.builder()
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TableSchemaDefinitionPartitionKeyArgs].
 */
@PulumiTagMarker
public class TableSchemaDefinitionPartitionKeyArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    /**
     * @param value The name of the partition key column.
     */
    @JvmName("imessukavslsksja")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the partition key column.
     */
    @JvmName("bcogvnmvxffofdtw")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): TableSchemaDefinitionPartitionKeyArgs =
        TableSchemaDefinitionPartitionKeyArgs(
            name = name ?: throw PulumiNullFieldException("name"),
        )
}
